/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.rpm.ui.preferences;

import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.extension.rpm.ui.Messages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Table;

public class RuntimeListComposite extends Composite {
	private Button addButton;
	private Button editDeviceButton;
	private Button editRuntimeButton;
	private Button removeButton;
	private TableViewer runtimeTableViewer;
	private CheckboxTableViewer deviceTableViewer;
	
	public RuntimeListComposite(Composite parent) {
		super(parent, SWT.NONE);		
		setLayout(new FillLayout());
		
		GUIComponents gc = new GUIComponents();
		gc.createSashForm1(this);
		runtimeTableViewer = new TableViewer(gc.getRuntimeTable());
		deviceTableViewer = new CheckboxTableViewer(gc.getDeviceTable());
		addButton = gc.getAddButton();
		editRuntimeButton = gc.getEditRuntimeButton();
		editDeviceButton = gc.getEditDeviceButton();
		removeButton = gc.getRemoveButton();		
	}
	
	public Button getAddButton() {
		return addButton;
	}

	public Button getEditRuntimeButton() {
		return editRuntimeButton;
	}

	public Button getEditDeviceButton() {
		return editDeviceButton;
	}
	
	public Button getRemoveButton() {
		return removeButton;
	}

	public TableViewer getRuntimeTableViewer() {
		return runtimeTableViewer;
	}

	public CheckboxTableViewer getDeviceTableViewer() {
		return deviceTableViewer;
	}	
}

class GUIComponents {
	private SashForm sashForm1 = null;
	private Group group = null;
	private Group group1 = null;
	private Composite composite1 = null;
	private Table table = null;
	private Table table1 = null;
	private Button button3 = null;
	private Composite composite2 = null;
	private Composite composite3 = null;
	private ScrolledComposite scrolledComposite3 = null;
	private Composite composite4 = null;
	private Button button4 = null;
	private Button button5 = null;
	private Button button6 = null;

	public Table getRuntimeTable() {
		return table1;
	}

	public Table getDeviceTable() {
		return table;
	}
	
	public Button getAddButton() {
		return button4;
	}

	public Button getEditRuntimeButton() {
		return button5;
	}

	public Button getEditDeviceButton() {
		return button3;
	}
	
	public Button getRemoveButton() {
		return button6;
	}

	/**
	 * This method initializes sashForm1	
	 *
	 */
	public void createSashForm1(Composite parent) {
		sashForm1 = new SashForm(parent, SWT.VERTICAL);
		sashForm1.setBackground(Display.getCurrent().getSystemColor(SWT.COLOR_GRAY));
		createGroup();
		createGroup1();
	}

	/**
	 * This method initializes group	
	 *
	 */
	private void createGroup() {
		group = new Group(sashForm1, SWT.NONE);
		group.setText(Messages.RuntimeListComposite_RuntimePlatforms);
		group.setLayout(new FillLayout());
		createComposite2();
	}

	/**
	 * This method initializes group1	
	 *
	 */
	private void createGroup1() {
		group1 = new Group(sashForm1, SWT.NONE);
		group1.setText(Messages.RuntimeListComposite_Devices);
		group1.setLayout(new FillLayout());
		createComposite3();
	}

	/**
	 * This method initializes table	
	 *
	 */
	private void createTable() {
		table = new Table(composite3, SWT.CHECK | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE /*| SWT.FULL_SELECTION*/);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		GridData data = new GridData(GridData.FILL_BOTH);
		table.setLayoutData(data);

	}

	/**
	 * This method initializes table1	
	 *
	 */
	private void createTable1() {
		table1 = new Table(composite2, SWT.FILL | SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL | SWT.SINGLE | SWT.FULL_SELECTION);
		table1.setHeaderVisible(true);
		table1.setLinesVisible(true);

		GridData data = new GridData(GridData.FILL_BOTH);
		table1.setLayoutData(data);
	}

	/**
	 * This method initializes composite2	
	 *
	 */
	private void createComposite2() {
		composite2 = new Composite(group, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite2.setLayout(gridLayout);
		createTable1();
		createScrolledComposite3();
	}

	/**
	 * This method initializes composite3	
	 *
	 */
	private void createComposite3() {
		composite3 = new Composite(group1, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 2;
		composite3.setLayout(gridLayout);
		createTable();
		createComposite1();
	}

	/**
	 * This method initializes scrolledComposite3	
	 *
	 */
	private void createScrolledComposite3() {
		scrolledComposite3 = new ScrolledComposite(composite2, SWT.BORDER);
		createComposite4();
		scrolledComposite3.setContent(composite4);
		
		GridData data = new GridData(GridData.FILL_VERTICAL);
		data.horizontalAlignment = SWT.CENTER;
		scrolledComposite3.setLayoutData(data);
	}

	/**
	 * This method initializes composite4	
	 *
	 */
	private void createComposite4() {
		GridLayout gl = new GridLayout();
		gl.marginHeight = 2;
		gl.marginWidth = 2;
		gl.horizontalSpacing = 1;
		gl.verticalSpacing = 1;
		gl.numColumns = 1;
		
		composite4 = new Composite(scrolledComposite3, SWT.NONE);
		button4 = new Button(composite4, SWT.PUSH);
		button4.setText(Messages.RuntimeListComposite_Add);
		button5 = new Button(composite4, SWT.PUSH);
		button5.setText(Messages.RuntimeListComposite_Edit);
		button6 = new Button(composite4, SWT.PUSH);
		button6.setText(Messages.RuntimeListComposite_Remove);

		composite4.setLayout(gl);
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		button4.setLayoutData(data);
		button5.setLayoutData(data);
		button6.setLayoutData(data);
		composite4.setSize(composite4.computeSize(60, SWT.DEFAULT));
	}
	
	/**
	 * This method initializes composite1	
	 *
	 */
	private void createComposite1() {	
		ScrolledComposite sc = new ScrolledComposite(composite3, SWT.BORDER);		

		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		sc.setLayout(gridLayout);
		
		GridLayout gl = new GridLayout();
		gl.numColumns = 1;
		gl.marginHeight = 2;
		gl.marginWidth = 2;
		gl.horizontalSpacing = 1;
		gl.verticalSpacing = 1;
		
		composite1 = new Composite(sc, SWT.NONE);
		button3 = new Button(composite1, SWT.PUSH);
		button3.setText(Messages.RuntimeListComposite_CompositeEditButton);
		
		composite1.setLayout(gl);
		
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		button3.setLayoutData(data);
		
		sc.setContent(composite1);
		GridData data2 = new GridData(GridData.FILL_VERTICAL);
		data2.horizontalAlignment = SWT.CENTER;
		sc.setLayoutData(data2);
		composite1.setSize(composite1.computeSize(60, SWT.DEFAULT));
	}
}
