/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dm.ui.preferences;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.api.devices.DevicePlatform;


public class DevicePlatformListSorter extends ViewerSorter {

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ViewerSorter#compare(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	public int compare(Viewer viewer, Object e1, Object e2) {
		
		if(e1 instanceof DevicePlatform){
			
			DevicePlatform dp1 = (DevicePlatform)e1;
			DevicePlatform dp2 = (DevicePlatform)e2;
			
			return (dp1.getName() != null ? dp1.getName() : "").compareToIgnoreCase((dp2.getName() != null ? dp2.getName() : "")); //$NON-NLS-1$ //$NON-NLS-2$
		}
		else
			return super.compare(viewer, e1, e2);
	}
}
