/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.preverify.internal.result;

import org.eclipse.mtj.api.model.preverifier.IFieldErrorInformation;

/**
 * Implementation of the IFieldErrorInformation interface.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:52:02 $
 * <br>
 * @author Craig Setera
 */
public class FieldErrorInformation implements IFieldErrorInformation {
	private String name;
	private String typeDescription;
	
	/**
	 * Construct a new field error information.
	 * 
	 * @param name
	 * @param typeDescription
	 */
	public FieldErrorInformation(String name, String typeDescription) {
		super();
		this.name = name;
		this.typeDescription = typeDescription;
	}

	/**
	 * @see eclipseme.preverifier.results.IFieldErrorInformation#getName()
	 */
	public String getName() {
		return name;
	}

	/**
	 * @see eclipseme.preverifier.results.IFieldErrorInformation#getTypeDescription()
	 */
	public String getTypeDescription() {
		return typeDescription;
	}
}
