package org.eclipse.mtj.core.library;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipFile;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.library.config.LibrarySpecification;
import org.eclipse.mtj.core.version.Version;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MtjCoreLibraryPlugin extends Plugin {

	public static final String LIBRARY_TYPE_CONFIGURATION = "configuration"; //$NON-NLS-1$
	public static final String LIBRARY_TYPE_PROFILE = "profile"; //$NON-NLS-1$
	public static final String LIBRARY_TYPE_SERVICE_API = "api"; //$NON-NLS-1$
	
	public static final String J2ME_LIBRARIES_ID = "libraries"; //$NON-NLS-1$
	
	// The configuration specifications provided by extension points
	private LibrarySpecification[] librarySpecs;
	
	//The shared instance.
	private static MtjCoreLibraryPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public MtjCoreLibraryPlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MtjCoreLibraryPlugin getDefault() {
		return plugin;
	}

	public static List<LibrarySpecification> getCorrLibrarySpecifications(File libraryFile) throws CoreException {
		LibrarySpecification[] libs = getLibrarySpecifications();
		List<LibrarySpecification> list = new BasicEList();
		
		ZipFile zipFile = null;
		try {
			zipFile = new ZipFile(libraryFile);
			for (int i = 0; i < libs.length; i++) {
				if (zipFile.getEntry(libs[i].getClassEntry()) != null) {
					list.add(libs[i]);					
				}
			}
		} catch (IOException e) {
			//TODO implement error handling
		} finally {
			if (zipFile != null) {
				try { zipFile.close(); } catch (IOException e) {}
			}
		}

		return list;
	}
	/*	
	public static LibrarySpecification getCorrLibrarySpecification(File libraryFile) throws CoreException {
		LibrarySpecification[] libs = getLibrarySpecifications();
		
		LibrarySpecification ret = null;
		ZipFile zipFile = null;
		try {
			zipFile = new ZipFile(libraryFile);
			for (int i = 0; i < libs.length; i++) {
				if (zipFile.getEntry(libs[i].getClassEntry()) != null) {
					ret = libs[i];
					break;
				}
			}
		} catch (IOException e) {
			//TODO implement error handling
		} finally {
			if (zipFile != null) {
				try { zipFile.close(); } catch (IOException e) {}
			}
		}

		return ret;
	}
	*/
	public static LibrarySpecification[] getLibrarySpecifications(File libraryFile, String libraryType) throws CoreException {
		LibrarySpecification[] libs = getLibrarySpecifications();
		
		ArrayList list = new ArrayList();
		ZipFile zipFile = null;
		try {
			zipFile = new ZipFile(libraryFile);
			for (int i = 0; i < libs.length; i++) {
				if (libs[i].getType().equals(libraryType) && zipFile.getEntry(libs[i].getClassEntry()) != null) {
					list.add(libs[i]);
				}
			}
		} catch (IOException e) {
			//TODO implement error handling
		} finally {
			if (zipFile != null) {
				try { zipFile.close(); } catch (IOException e) {}
			}
		}

		LibrarySpecification[] ret = new LibrarySpecification[list.size()];
		for (int i = 0; i < list.size(); i++) {
			ret[i] = (LibrarySpecification)list.get(i);
		}
		                     
		return ret;
	}
	
	/**
	 * Return the configuration specifications provided by the plugin
	 * extension points.
	 * 
	 * @return the configuration specifications
	 * @throws CoreException 
	 */
	public static LibrarySpecification[] getLibrarySpecifications() 
		throws CoreException 
	{
		MtjCoreLibraryPlugin plugin = getDefault();
		if (plugin.librarySpecs == null) {
			IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(
					MtjCorePlugin.getId(), 
					J2ME_LIBRARIES_ID); 
			IConfigurationElement[] configElements = point.getConfigurationElements();
			plugin.librarySpecs = new LibrarySpecification[configElements.length];	
			
			for (int i = 0; i < configElements.length; i++) {
				plugin.librarySpecs[i] = createComponentSpecification(configElements[i]);
			}
		}
		
		return plugin.librarySpecs;
	}
	
	/**
	 * Create a component specification for the specified configuration
	 * element
	 * @param element
	 * @return
	 * @throws CoreException 
	 */
	private static LibrarySpecification createComponentSpecification(IConfigurationElement element) 
		throws CoreException 
	{
		String id = element.getAttribute("id"); //$NON-NLS-1$
		String type = element.getAttribute("type"); //$NON-NLS-1$
		String name = element.getAttribute("name"); //$NON-NLS-1$
		String label = element.getAttribute("label"); //$NON-NLS-1$
		String versionString = element.getAttribute("version"); //$NON-NLS-1$
		Version version = new Version(versionString);
		String binFile = element.getAttribute("binFile"); //$NON-NLS-1$
		String classEntry = element.getAttribute("classEntry"); //$NON-NLS-1$
		String sourceFile = element.getAttribute("sourceFile"); //$NON-NLS-1$
		String javadocFile = element.getAttribute("javadocFile"); //$NON-NLS-1$
		String fileNameList = element.getAttribute("fileNameList"); //$NON-NLS-1$

		LibrarySpecification specification = new LibrarySpecification();
		specification.setIdentifier(id);
		specification.setType(type);
		specification.setName(name);
		specification.setLabel(label);
		specification.setVersion(version);
		specification.setClassEntry(classEntry);
		specification.setBinFile(binFile);
		specification.setSourceFile(sourceFile);
		specification.setJavadocFile(javadocFile);
		specification.setFileNameList(fileNameList);
		
		return specification;
	}

}
