/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.action;

import java.lang.reflect.InvocationTargetException;
import java.util.Vector;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class PackageMidletSuiteAction implements IWorkbenchWindowActionDelegate, IObjectActionDelegate
{

	private IWorkbenchWindow fWorkbenchWindow;

	private IStructuredSelection fSelection;

	public void run(IAction action) {

//		MidletSuitePackagingWizard midletSuitePackagingWizard = new MidletSuitePackagingWizard(fSelection);
		Shell shell = MtjDevIdePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
//		WizardDialog wizardDialog = new WizardDialog(shell, midletSuitePackagingWizard);
//		wizardDialog.create();
//		int result= wizardDialog.open();
//		if (result != IDialogConstants.OK_ID) {
////			System.out.println("Didn't open");
//		}

		ProgressMonitorDialog d = new ProgressMonitorDialog(shell);

//		AntRunner antRunner = new AntRunner ();
//		IFile file = new IFile ();
//		antRunner.setBuildFileLocation(file.getRawLocation().toOSString());
//		antRunner.run(d.getProgressMonitor());
		
//		JarPackageData fJarPackage= new JarPackageData();
//		
//		IJarExportRunnable runnable = fJarPackage.createJarExportRunnable(getShell());
//		ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
//
//		try {
//			d.run(true, false, runnable);
//		} catch (InvocationTargetException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} catch (InterruptedException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		} 
		
		IProject project;

		if (fSelection.getFirstElement() instanceof IJavaProject) {
			project = ((IJavaProject)fSelection.getFirstElement()).getProject();
		} else {
			project = (IProject)fSelection.getFirstElement();
		}
		
		try {
			
	        Shell parentShell= getShell();
	        JarPackageData description= new JarPackageData();
//	        description.setSaveManifest(false);
	        description.setExportClassFiles(true);
	        


	        
			IResource[] projectMembers = project.members();
	
			Vector exportFiles = new Vector ();

			for (int i = 0; i < projectMembers.length; i++)
			{
				IResource thisMember = projectMembers[i];
				if (thisMember instanceof IFolder)
				{
					IFolder folder = (IFolder)thisMember;
					if (folder.getName().compareTo ("META-INF") == 0) //$NON-NLS-1$
					{
						IResource manifest = folder.findMember("MANIFEST.MF"); //$NON-NLS-1$
						if (manifest != null)
						{
					        description.setSaveManifest(true);
							description.setManifestLocation(manifest.getFullPath());
							description.setUsesManifest(true);
							description.setGenerateManifest(false);
							thisMember = manifest;
						}
					}
				}
				// Need to walk bin directory here next
				if (thisMember instanceof IFile)
				{
					String fileExtension = thisMember.getFileExtension();
					if (fileExtension != null)
					{
						if (thisMember.getName().compareTo ("MANIFEST.MF") == 0) //$NON-NLS-1$
							exportFiles.add(thisMember);
						else if (fileExtension.compareTo("class") == 0) //$NON-NLS-1$
							exportFiles.add(thisMember);
						else if (fileExtension.compareTo ("jad") == 0) //$NON-NLS-1$
							exportFiles.add(thisMember);
					}
				}

			}
		        IPath location= new Path("C:/myjar.jar"); //$NON-NLS-1$
		        description.setJarLocation(location);
//		        description.setManifestMainClass(mainType);
		        description.setElements(exportFiles.toArray());
		        IJarExportRunnable runnable= description.createJarExportRunnable(parentShell);
		        try {
		            new ProgressMonitorDialog(parentShell).run(true,true, runnable);
		        } catch (InvocationTargetException e) {
		            // An error has occurred while executing the operation
		        } catch (InterruptedException e) {
		            // operation has been canceled.
		        }
		        
		} catch (CoreException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

	}


	/**
	 * @see IActionDelegate
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		fSelection = (IStructuredSelection) selection;


		// Update the action enablement based on the selection.
		if (action != null)
			action.setEnabled(isEnabled(getSelection()));
	}

	protected boolean isEnabled(IStructuredSelection selection) {
		return true;
	}

	/**
	 * @see IEditorActionDelegate
	 */
	public void setActiveEditor(IAction action, IEditorPart targetEditor) {
		fWorkbenchWindow = targetEditor.getEditorSite().getWorkbenchWindow();

		selectionChanged(action, targetEditor.getEditorSite()
				.getSelectionProvider().getSelection());
	}

	/**
	 * @see IObjectActionDelegate
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		fWorkbenchWindow = targetPart.getSite().getWorkbenchWindow();

		if (targetPart.getSite().getSelectionProvider() != null) {
			selectionChanged(action, targetPart.getSite()
					.getSelectionProvider().getSelection());
		}
	}

	/**
	 * @see IViewActionDelegate
	 */
	public void init(IViewPart view) {
		fWorkbenchWindow = view.getSite().getWorkbenchWindow();

		selectionChanged(null, view.getSite().getSelectionProvider()
				.getSelection());
	}

	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void dispose() {
	}

	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void init(IWorkbenchWindow window) {
		fWorkbenchWindow = window;

		selectionChanged(null, window.getSelectionService().getSelection());
	}

	protected IStructuredSelection getSelection() {
		if (fSelection instanceof IStructuredSelection)
			return (IStructuredSelection) fSelection;
		else
			return new StructuredSelection();
	}

	
	protected Shell getShell() {
		return getWorkbenchWindow().getShell();
	}

	protected IWorkbench getWorkbench() {
		return getWorkbenchWindow().getWorkbench();
	}

	protected IWorkbenchWindow getWorkbenchWindow() {
		return fWorkbenchWindow;
	}
}
