/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation and others                                        
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 
package org.eclipse.mtj.extension.devide.nature;

import java.util.ArrayList;
import java.util.Arrays;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;

/**
 * Project nature for J2ME projects.
 */
public class MtjNature implements IProjectNature {
	
	public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide"; //$NON-NLS-1$

	public static final String MTJ_NATURE_ID = PLUGIN_ID + ".nature"; //$NON-NLS-1$

	/**
	 * Return a boolean indicating whether the specified project has the J2ME
	 * nature associated with it.
	 * 
	 * @param project the project to be tested for the J2ME nature
	 * @return a boolean indicating whether the specified project has
	 * the J2ME nature
	 * @throws CoreException
	 */
	public static boolean hasMtjNature(IProject project)
		throws CoreException
	{
		return project.hasNature(MTJ_NATURE_ID);
	}
	
	public static String getNatureID ()
	{
		return MTJ_NATURE_ID;
	}

	private IProject project;
	
	/**
	 * Default constructor.
	 */
	public MtjNature() {
	}

	/**
	 * @see IProjectNature#configure
	 */
	public void configure() throws CoreException {
		addMtjBuilders();
	}

	/**
	 * @see IProjectNature#deconfigure
	 */
	public void deconfigure() throws CoreException {
	}

	/**
	 * @see IProjectNature#getProject
	 */
	public IProject getProject() {
		return project;
	}

	/**
	 * @see IProjectNature#setProject
	 */
	public void setProject(IProject project) {
		this.project = project;
	}

	/**
	 * Add the preverification builder to the project.
	 */
	private void addMtjBuilders() 
		throws CoreException 
	{
		boolean updated = false;
		IProjectDescription description = getProject().getDescription();
		ICommand[] commands = description.getBuildSpec();
		ArrayList commandsList = new ArrayList(Arrays.asList(commands));
		ICommand command = null;
		
		//Not yet this ... A.Laurila 23.3.2006
		// Add the preverifier if it is not in the builder list
		//ICommand command = newCommand(description, IEclipseMtjCoreConstants.MTJ_PREVERIFIER_ID);
		if (commandsList!= null && !commandsList.contains(command)) {
			commandsList.add(command);
			updated = true;
		}
		
		// Add the preprocessor if it is not in the builder list
//		command = newCommand(description, IEclipseMECoreConstants.J2ME_PREPROCESSOR_ID);
//		if (!commandsList.contains(command)) {
//			commandsList.add(0, command);
//			updated = true;
//		}

		// If there were updates to the command list, go ahead and set the
		// project description
		if (updated) {
			ICommand[] newCommands =
				(ICommand[]) commandsList.toArray(new ICommand[commandsList.size()]);
			description.setBuildSpec(newCommands);
			getProject().setDescription(description, null);
		}
	}

	/**
	 * Create a new command instance for the specified builder.
	 * 
	 * @param description
	 * @param id
	 * @return
	 */
	private ICommand newCommand(IProjectDescription description, String id) {
		ICommand command = description.newCommand();
		command.setBuilderName(id);
		
		return command;
	}
}
