/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *

* Contributors: 
*IBM - initial API and implementation 
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.mtj.jad.util.MidletSearchEngine;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

/**
 * MyDialog.java 2006 Mar 16, 2006 1:29:43 PM @author khorowit
 *
 */
public class MidletAdditionDialog extends Dialog implements SelectionListener {

	IProject project;
	JadFileDescriptor jadFileDescriptor;
	MIDletDescriptor midlet;
	
	Text midletName;
	Text midletIcon;
	List midletList;

	/**
     * The custom dialog area.
     */
 
	public MidletAdditionDialog(IProject project, JadFileDescriptor jadFileDescriptor, Shell parentShell) {
		super(parentShell);
		this.project = project;
		this.jadFileDescriptor = jadFileDescriptor;
		midlet = new MIDletDescriptor ("", "", ""); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
	}

//	@Override
//	protected Image getImage() {
//		// TODO Auto-generated method stub
//		return null;
//	}
//	
    protected Control createDialogArea(Composite parent) {
    	
    	FormToolkit formToolkit = new FormToolkit(parent.getDisplay());
		Form form = formToolkit.createForm(parent);
		Composite body = form.getBody();

		GridLayout bodyLayout  = new GridLayout();
		bodyLayout.numColumns = 1;

		body.setLayout(bodyLayout);
	
		// Name of the Midlet
		// Icon for this MIDlet: (Browse)
		// Box with Available MIDlets
		
		Composite midletNameBox = formToolkit.createComposite(body);
		midletName = FormToolkitTemplate.createTextEntry(Messages.MidletAdditionDialog_Name_of_MIDlet, "", formToolkit, midletNameBox); //$NON-NLS-1$
		midletName.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				midlet.setName(midletName.getText());
			}
		});
		GridLayout midletNameLayout = new GridLayout ();
		midletNameLayout.numColumns = 2;
		midletNameBox.setLayout(midletNameLayout);
		midletNameBox.setLayoutData(new GridData (GridData.FILL_HORIZONTAL));
		formToolkit.paintBordersFor(midletNameBox);
		
		// Composite parent with Text and browse button
		Composite iconBox = formToolkit.createComposite(body);
		GridLayout iconBoxLayout = new GridLayout ();
		iconBoxLayout.numColumns = 3;
		iconBox.setLayout(iconBoxLayout);
		midletIcon = FormToolkitTemplate.createTextEntry(Messages.MidletAdditionDialog_Icon_for_MIDlet, "", formToolkit, iconBox); //$NON-NLS-1$
		midletIcon.addModifyListener(new ModifyListener () {

			public void modifyText(ModifyEvent e) {
				midlet.setIcon(midletIcon.getText());
			}
		});

		midletIcon.setLayoutData(new GridData (GridData.FILL_HORIZONTAL));
		Button midletIconButton = formToolkit.createButton(iconBox, Messages.MidletAdditionDialog_Browse, SWT.PUSH);
		formToolkit.paintBordersFor(iconBox);
		
//		Composite client = formToolkit.createComposite (body);
//		Table t = formToolkit.createTable(client, SWT.NULL);
//		GridData gd = new GridData(GridData.FILL_BOTH);
//		gd.heightHint = 20;
//		gd.widthHint = 100;
//		t.setLayoutData(gd);
//		formToolkit.paintBordersFor(client);



//		 List box with filled in data
		midletList = createMidletClassSelection (formToolkit, body);
		midletList.addSelectionListener(new SelectionListener () {

			public void widgetSelected(SelectionEvent e) {
				String[] selection = midletList.getSelection();
				midlet.setClassname(selection[0]);			
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				String[] selection = midletList.getSelection();
				midlet.setClassname(selection[0]);
			}
		
		});
		
		formToolkit.paintBordersFor(body);
        return body;
    }

	private List createMidletClassSelection(FormToolkit formToolkit, Composite parent) {
		// Create a search engine and find all

		Composite fMidletSelectionControl = formToolkit.createComposite(parent);
		
		GridLayout layout = new GridLayout();
//		layout.marginHeight = 0;
//		layout.marginWidth = 0;
		layout.numColumns = 1;
		fMidletSelectionControl.setLayout(layout);
		fMidletSelectionControl.setLayoutData(new GridData (GridData.FILL_BOTH));
		
		Label label = new Label(fMidletSelectionControl, SWT.SHADOW_NONE|SWT.LEFT);
		label.setText(Messages.MidletAdditionDialog_Availabe_Midlets); 
//		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
//		label.setLayoutData(gd);
		
		List list = new List(fMidletSelectionControl, SWT.BORDER |SWT.V_SCROLL|SWT.H_SCROLL|SWT.SINGLE);
		GridData gd2 = new GridData(GridData.FILL_BOTH);
		list.setLayoutData(gd2);
		list.addSelectionListener(this);
//		FormData data = new FormData();
//		data.height = 200;
//		data.width = parent.computeSize(SWT.DEFAULT,SWT.DEFAULT,true).x;
//		fMidletSelectionControl.setLayoutData(data);
//		
		try {
			ProgressMonitorDialog pmd = new ProgressMonitorDialog(getShell());
			pmd.open();
			java.util.List midlets = MidletSearchEngine.searchSubtypes(project, pmd.getProgressMonitor());
			pmd.close();
			
			int toBeSelected = 0;
			
			for (int i = 0, max = midlets.size(); i < max; i++) {
				String name = ((IType) midlets.get(i)).getFullyQualifiedName();
				if (midlet!=null && name.equals(midlet.getClassname())) {
					toBeSelected = i;
				}
				
				list.add(name);
				
				if (i == toBeSelected) {
					list.setSelection(i);
					list.setTopIndex(i);
					midlet.setClassname(name);
//					fClassName=name;	
				}
			}

		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (CoreException e) {
			e.printStackTrace();
		}
		
		
		formToolkit.paintBordersFor(fMidletSelectionControl);
		return list;

//		return null;
	}

	public void widgetSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}

	public void widgetDefaultSelected(SelectionEvent e) {
		// TODO Auto-generated method stub
		
	}

	public MIDletDescriptor getMIDletDescriptor() {
		if (getReturnCode() == OK)
		{
			String name = midlet.getName();
			String className = midlet.getClassname();
			String iconName = midlet.getIcon();
			MIDletDescriptor midletDescriptor = new MIDletDescriptor(name, iconName, className);
			return midletDescriptor;
		}
		else
			return null;
	}
	

	

}
