/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import org.eclipse.core.resources.IProject;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/**
 * MidletSuiteRequiredSection.java 2006 Mar 1, 2006 4:08:21 PM @author khorowit
 *
 */
public class MidletSuiteSectionMidlet extends MidletSuiteSectionTemplate {

	IProject project;
	JadFileDescriptor jadFile;
	FormToolkit formToolkit;
	
	Composite parentComposite;
	Composite sectionClient;
	Table midletTable;
	Button midletButtonAdd;
	Button midletButtonDelete;	
	TableColumn midletName;
	TableColumn midletIcon;
	TableColumn mdiletClass;
	
    boolean resizeEventCalled = false;

	/**
	 * A constructor for MidletSuiteRequiredSection.java
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public MidletSuiteSectionMidlet(JadFileDescriptor jadFileDescriptor, IProject parentProject, Composite parent, FormToolkit toolkit,
			int style) {
		super(parent, toolkit, style);
		this.project = parentProject;
		parentComposite = parent;
		jadFile = jadFileDescriptor;
		formToolkit = toolkit;
		
		Section section = getSection();
		
		section.setText(Messages.MidletSuiteSectionMidlet_Midlets);
		section.setDescription(Messages.MidletSuiteSectionMidlet_Description+
		      ""); //$NON-NLS-1$
		
		
		
		sectionClient = toolkit.createComposite(section);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
//		GridData gd = new GridData();
		
		
		midletTable = toolkit.createTable (sectionClient, SWT.FULL_SELECTION | SWT.MULTI);
	    midletTable.setHeaderVisible(true);
	    midletTable.setLinesVisible(true);
	    GridData data = new GridData(GridData.FILL_BOTH);
	    data.grabExcessHorizontalSpace = true;
	    midletTable.setLayoutData(data);
	    
	    int midletQuantity = jadFileDescriptor.getMIDletCount();
	    
		midletName = new TableColumn(midletTable, SWT.NONE);
		midletName.setText(Messages.MidletSuiteSectionMidlet_Name);
		midletIcon = new TableColumn(midletTable, SWT.NONE);
		midletIcon.setText(Messages.MidletSuiteSectionMidlet_Icon);
		mdiletClass = new TableColumn(midletTable, SWT.NONE);
		mdiletClass.setText(Messages.MidletSuiteSectionMidlet_Class);
		
		for (int i = 1; i <= midletQuantity; i++)
		{
			MIDletDescriptor midlet = jadFileDescriptor.getMIDlet(i);

			TableItem item = new TableItem (midletTable, SWT.NONE);
			item.setText (0, midlet.getName());
			item.setText (1, midlet.getIcon());
			item.setText (2, midlet.getClassname());
		}
		
		// Delete once working
//		  for (int i = 0; i < 10; i++) {
//		      TableItem item = new TableItem(midletTable, SWT.NONE);
//		      for (int j = 0; j < 3; j++) {
//		        item.setText(j, "Row " + i + ", Column " + j);
//		      }
//		    }
		
		
	    for (int i = 0, n = midletTable.getColumnCount(); i < n; i++) {
	    	midletTable.getColumn(i).pack();
	    }

	  
		Composite buttonColumn = toolkit.createComposite(sectionClient);
		
		GridLayout buttonLayout = new GridLayout();
		buttonLayout.numColumns = 1;
	    
		
		midletButtonAdd = toolkit.createButton(buttonColumn, Messages.MidletSuiteSectionMidlet_Add, SWT.PUSH);
		midletButtonAdd.setLayoutData (new GridData (GridData.FILL_HORIZONTAL));
		
		midletButtonAdd.addSelectionListener(new SelectionListener () {

			public void widgetSelected(SelectionEvent e) {
				// TODO Auto-generated method stub

				Shell shell = parentComposite.getShell();

				MidletAdditionDialog a = new MidletAdditionDialog (project, jadFile, shell);
				a.open();
				MIDletDescriptor returnMidlet = a.getMIDletDescriptor();
				int rowCount = midletTable.getItemCount();
				addMidlet (returnMidlet);
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
			
		});
		
		midletButtonDelete = toolkit.createButton(buttonColumn, Messages.MidletSuiteSectionMidlet_Delete, SWT.PUSH);
		midletButtonDelete.setLayoutData (new GridData (GridData.FILL_HORIZONTAL));
		midletButtonDelete.addSelectionListener(new SelectionListener () {

			public void widgetSelected(SelectionEvent e) {
			}

			public void widgetDefaultSelected(SelectionEvent e) {
			}
			
		});
		
		toolkit.paintBordersFor(buttonColumn);
		buttonColumn.setLayout(buttonLayout);

		toolkit.paintBordersFor(sectionClient);
		sectionClient.setLayout(layout);

		
	    
		section.setClient(sectionClient);
		
	}
	
	/*
	 * Update the list and descriptor,
	 * and synchronize the added/removed Vectors.
	 */
	private void addMidlet(MIDletDescriptor d) {
		TableItem item = new TableItem (midletTable, SWT.NONE);
		item.setText (0, d.getName());
		item.setText (1, d.getIcon());
		item.setText (2, d.getClassname());
		jadFile.addMIDlet(d);


	
	}

}
