/*******************************************************************************
* Copyright (c) 2000, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.core.ui.constants.ProjectCreationConstants;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class MTJNewProjectMidletWizard extends BasicNewProjectResourceWizard implements IExecutableExtension {
	protected MTJNewProjectWizardPage fJavaPage;
	protected WizardNewProjectCreationPage fMainPage;
	protected MTJNewProjectSelectLibraryWizardPage fJavaSDKPage;
	protected MidletSuitePackagingWizardPage fMidletSuitePage;
	protected IConfigurationElement fConfigElement;
	protected MTJNewProjectTemplatePage fTemplatesPage;

	public ProjectCreationModel projectModel = new ProjectCreationModel();
	
	public MTJNewProjectMidletWizard() {
		super();
		projectModel.setProperty(ProjectCreationConstants.PCC_NATURE, MtjNature.getNatureID());
	}

	protected void createMainPage() {
		fMainPage= new ProjectCreationPage(Messages.MTJNewProjectMidletWizard_Id); 
		
		String msg = Messages.MTJNewProjectMidletWizard_MTJ_midlet_project_creation;
		fMainPage.setTitle(msg);
		
		msg = Messages.MTJNewProjectMidletWizard_Create_JavaMe_Midlet;
		fMainPage.setDescription(msg);
	}
	
	/**
	 * Gets the mainPage.
	 * @return Returns a WizardNewProjectCreationPage
	 */
	public WizardNewProjectCreationPage getMainPage() {
		return fMainPage;
	}

	protected void createJavaPage(MTJNewProjectSelectLibraryWizardPage javaSDKPage, MidletSuitePackagingWizardPage midletPage) {
		fJavaPage= new MTJNewProjectWizardPage(ResourcesPlugin.getWorkspace().getRoot(), fMainPage, projectModel, javaSDKPage, midletPage);
		fJavaPage.setForMidp(true);
	}
	
	/**
	 * Gets the javaPage.
	 * @return Returns a NewJavaProjectWizardPage
	 */
	public MTJNewProjectWizardPage getJavaPage() {
		return fJavaPage;
	}

	protected void createJavaSDKPage() {
		fJavaSDKPage = new MTJNewProjectSelectLibraryWizardPage(Messages.MTJNewProjectMidletWizard_Select_device_and_libraries);

		String msg = Messages.MTJNewProjectMidletWizard_MTJ_Project_creation;
		fJavaSDKPage.setTitle(msg);

		msg = Messages.MTJNewProjectMidletWizard_Select_device_and_Libraries_2;
		fJavaSDKPage.setDescription(msg);
	}
	
	protected void createMidletSuitePackagingPage() {
		fMidletSuitePage = new MidletSuitePackagingWizardPage("", "", null); //$NON-NLS-1$ //$NON-NLS-2$
	}
	
	/**
	 * Allow a subclass to mofify the pages at this point
	 *
	 */
	protected void createOptionalPages()
	{
		createTemplatesPage();
	}
	/**
	 * Allow a subclass to mofify the pages at this point
	 *
	 */
	protected void addOptionalPages()
	{	
		addPage(fTemplatesPage);
	}
	
	/**
	 * Gets the Libraries Container Page.
	 * @return Returns a MTJNewProjectSelectLibraryWizardPage
	 */
	public MTJNewProjectSelectLibraryWizardPage getJavaSDKPage() {
		return fJavaSDKPage;
	}

	/**
	 * @see Wizard#addPages
	 */	
	public void addPages() {
		
		createMainPage();
		createJavaSDKPage();
		createMidletSuitePackagingPage ();
		createJavaPage(fJavaSDKPage, fMidletSuitePage);
		createOptionalPages ();
		
		addPage(fMainPage);
		addPage(fJavaSDKPage);
		addPage(fJavaPage);
		addPage(fMidletSuitePage);
		addOptionalPages();
	}		
	
	protected void createTemplatesPage() {
		fTemplatesPage = new MTJNewProjectTemplatePage(true);
	}

	/**
	 * @see Wizard#performFinish
	 */		
	public boolean performFinish() {
//		if (fJavaSDKPage != null)
//			fJavaSDKPage.updateBuildpath();
	 
		boolean result = false;
		try{
			
		RunnableActionExecutor executor = new RunnableActionExecutor(Messages.MTJNewProjectMidletWizard_Create_MTJ_midlet_project); 
		IRunnableWithProgress projectAction = new ProjectCreationAction(fJavaPage, fJavaSDKPage, fMidletSuitePage, fTemplatesPage, projectModel, getShell());
//		IRunnableWithProgress buildfileAction = new BuildfileCreationAction(fMainPage.getProjectHandle());
		
		executor.addAction(new RunnableAction(projectAction, ProjectCreationAction.NAME, 10));
//		executor.addAction(new RunnableAction(buildfileAction, BuildfileCreationAction.NAME, 5));
		 result = executor.runWithDialog(getShell());

		}
		catch (NullPointerException e)
		{
		 e.printStackTrace();
		}
		
		BasicNewProjectResourceWizard.updatePerspective(fConfigElement);
		
		return result;
	}
		
	/* (non-Javadoc)
	 * Method declared on IWorkbenchWizard.
	 */
	public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
		super.init(workbench, currentSelection);
		initializeDefaultPageImageDescriptor();
	}

	/**
	 * Stores the configuration element for the wizard.  The config element will be used
	 * in <code>performFinish</code> to set the result perspective.
	 */
	public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
		fConfigElement= cfig;
				
		initializeDefaultPageImageDescriptor();
		setWindowTitle(Messages.MTJNewProjectMidletWizard_New_Project); 
	}
	
	protected void initializeDefaultPageImageDescriptor() {
//		setDefaultPageImageDescriptor(J9PluginImages.DESC_WIZBAN_ME_PROJ);
	}	

	public String getProjectName ()
	{
		return getJavaPage().getProjectName();
	}
	
	public IProject getProject ()
	{
		return getJavaPage().getProject();
	}



}