/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/

package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;


/**
 * @author Rod
 *
 */
public class MTJNewProjectTemplatePage extends WizardPage {

	
	private Button useTemplateCheckBox;
	private List templatesList;
	
	private boolean useTemplate;
	private String templateToUse;
	
	private IProject fproject;
	private IPath templatesDir;
	private IPath srcPath;
	private String srcSegment;
	private boolean forMIDP;
	
	// Initialized through new project wizard
	public MTJNewProjectTemplatePage(boolean forMIDP) {
		super(""); //$NON-NLS-1$
		setTitle(Messages.MTJNewProjectTemplatePage_0);
		setMessage(Messages.MTJNewProjectTemplatePage_1);
		
		//Get the location of the templates. MIDP | PPRO
		templatesDir = MtjDevIdePlugin.getTemplatesPath
			(forMIDP == true ? MtjDevIdePlugin.MTJ_TEMPLATE_MIDP : MtjDevIdePlugin.MTJ_TEMPLATE_PPRO);
		srcSegment = MtjDevIdePlugin.getTemplatesSegments
			(forMIDP == true ? MtjDevIdePlugin.MTJ_TEMPLATE_MIDP : MtjDevIdePlugin.MTJ_TEMPLATE_PPRO);
		//Is this a new MIPD project or not?
		this.forMIDP = forMIDP;
	}
		
	/* (non-Javadoc)
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createControl(Composite parent) {
	
		Composite composite = new Composite(parent, SWT.NONE);
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		
		Composite c = new Composite(composite, SWT.NONE);
		GridLayout layout = new GridLayout(2, false);
		c.setLayout(layout);
		GridData data = new GridData(SWT.FILL, SWT.FILL, true, false);
		c.setLayoutData(data);
				
		useTemplateCheckBox = new Button(c, SWT.CHECK);
		GridData gd = new GridData(GridData.BEGINNING);
		useTemplateCheckBox.setSelection(false);
		useTemplateCheckBox.setLayoutData(gd);
		
		useTemplateCheckBox.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				
				if (getErrorMessage() != null && getErrorMessage().equals(Messages.MTJNewProjectTemplatePage_2))
					setErrorMessage(null);
				
				if(useTemplateCheckBox.getSelection()){
					if (templatesList.getSelectionCount() <= 0){
						setErrorMessage(Messages.MTJNewProjectTemplatePage_2);	
					} else {
						setTemplateToUse((String)templatesList.getItem(templatesList.getSelectionIndex()));
						setUseTemplate(true);
					}
				} else {
					setUseTemplate(false);
					setTemplateToUse(null);
				}
			}
		});

		
		Label useTemplateLabel = new Label(c, SWT.NONE);
		gd = new GridData(GridData.BEGINNING);
		useTemplateLabel.setLayoutData(gd);
		useTemplateLabel.setText(Messages.MTJNewProjectTemplatePage_3);
		
		templatesList = new List(composite,SWT.BORDER | SWT.SINGLE | SWT.V_SCROLL);
		gd = new GridData(GridData.FILL_BOTH);
		templatesList.setLayoutData(gd);
		templatesList.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent event) {
				if (templatesList.getSelectionCount() > 0){
					setTemplateToUse((String)templatesList.getItem(templatesList.getSelectionIndex()));
					useTemplateCheckBox.setSelection(true);
					setUseTemplate(true);
					if (getErrorMessage() != null && getErrorMessage().equals(Messages.MTJNewProjectTemplatePage_2))
						setErrorMessage(null);
				}
			}
		});
		addTemplateFilestoList(templatesList);
		
		setControl(composite);

	}

	private void addTemplateFilestoList(List templatesList) {
		
		String [] files = MtjDevIdePlugin.getTemplateFiles(forMIDP == true ? MtjDevIdePlugin.MTJ_TEMPLATE_MIDP : MtjDevIdePlugin.MTJ_TEMPLATE_PPRO);
		for (int i = 0; i < files.length; i++){
			templatesList.add(files[i]);
		}		
	}

	public void doFinish() {
		IPath templateSrcPath;
		IPath templateDestPath;
		String srcTemplateName;
		String dstJavaFileName;
		String dstJavaPackageName;

		srcTemplateName = getTemplateToUse();

		if (getErrorMessage() == null && useTemplate())
		{ 	
			if (srcTemplateName != null){
				
				templateSrcPath = (new Path(templatesDir.toString())).append(File.separator + srcTemplateName);
				dstJavaPackageName = createPackageName(templateSrcPath);
				dstJavaFileName = convertTemplatetoJava(templateSrcPath);
				templateDestPath = fproject.getLocation().addTrailingSeparator().append(getSrcPath().lastSegment());
	
				File newPackage = new File(templateDestPath.append(File.separator + dstJavaPackageName ).toString().toLowerCase());
				newPackage.mkdir();
	
				try {
					String fileInput;
					Path p = new Path(srcSegment + File.separator + getTemplateToUse());
					InputStream is = MtjDevIdePlugin.getDefault().getClass().getClassLoader().getResourceAsStream(p.toPortableString());
					BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(is));
					BufferedWriter out = new BufferedWriter(new FileWriter(templateDestPath.append(File.separator + dstJavaPackageName + File.separator + dstJavaFileName ).toString()));
					try {
						while ((fileInput=cmdOutputStream.readLine()) != null) {
					         out.write(fileInput);
					         out.newLine();
						}
					} catch (IOException e1) {
						e1.printStackTrace();
					} finally {
						fproject.refreshLocal(IResource.DEPTH_INFINITE, null);
						cmdOutputStream.close();
						out.close();
					}
				} catch (IOException e) {
					e.printStackTrace();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}			
		}		
	}

	private String createPackageName(IPath templateSrcPath) {
		String s = templateSrcPath.removeFileExtension().lastSegment().concat(Messages.MTJNewProjectTemplatePage_4);
		return s.toString();

	}

	private String convertTemplatetoJava(IPath templateSrcPath) {
		IPath s = new Path(templateSrcPath.removeFileExtension().lastSegment()).addFileExtension(Messages.MTJNewProjectTemplatePage_5);
		return s.toString();
	}

	public void setProject(IProject project) {
		this.fproject = project;
	}

	public IProject getProject() {
		return fproject;
	}

	public String getTemplateToUse() {
		return templateToUse;
	}

	public void setTemplateToUse(String templateToUse) {
		this.templateToUse = templateToUse;
	}

	public boolean useTemplate() {
		return useTemplate;
	}

	public void setUseTemplate(boolean useTemplate) {
		this.useTemplate = useTemplate;
	}

	public void setSrcPath(IClasspathEntry srcEntry) {
		srcPath = srcEntry.getPath();
	}
	
	public IPath getSrcPath(){
		return srcPath;
	}	
}
