/*******************************************************************************
* Copyright (c) 1998, 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;


import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class RunnableAction {
	private	IRunnableWithProgress fRunnable;
	private String fName;
	private int fUnits;
	
	public RunnableAction(IRunnableWithProgress runnable, String name, int units) {
		fRunnable = runnable;
		fName = name;
		fUnits = units;
	}
	
	public IRunnableWithProgress getRunnable(Shell toRun) {
		if (fRunnable instanceof IShellAction) {
			((IShellAction)fRunnable).setShell(toRun);
		}
		return fRunnable;
	}
	
	public String getName() {
		return fName;
	}
	
	public int getUnits() {
		return fUnits;
	}
	
	public interface IShellAction {
		// The shell the task should display any messages above, if any
		public void setShell(Shell s);
	}
}

