/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.extension.devide.utils;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;

/**
 * An IClasspathEntryVisitor that filters out the J2ME classpath
 * container and the base JRE containers and libraries.
 */
public abstract class FilteringClasspathEntryVisitor
	extends AbstractClasspathEntryVisitor 
{
	/**
	 * @see eclipseme.core.internal.utils.IClasspathEntryVisitor#visitContainer(IClasspathEntry, org.eclipse.jdt.core.IJavaProject, java.lang.String, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public boolean visitContainer(
		IClasspathEntry entry,
		IJavaProject javaProject, 
		String containerName, IProgressMonitor monitor)
			throws CoreException 
	{
		return
		!containerName.equals(J2MEClasspathContainer.J2ME_CONTAINER) &&
		!containerName.equals(JavaRuntime.JRE_CONTAINER);
	}
	
	public boolean visitProject(
		IClasspathEntry entry,
		IJavaProject javaProject, 
		IJavaProject classpathProject, 
		String natureId,
		IProgressMonitor monitor)
			throws CoreException 
	{
		return !EclipseUtil.isProjectOfNature(classpathProject.getProject().getName(), natureId);
	}
	
	/**
	 * @see eclipseme.core.internal.utils.IClasspathEntryVisitor#visitVariable(IClasspathEntry, org.eclipse.jdt.core.IJavaProject, java.lang.String, org.eclipse.core.runtime.IProgressMonitor)
	 */
	public boolean visitVariable(
		IClasspathEntry entry, 
		IJavaProject javaProject,
		String variableName, IProgressMonitor monitor) 
			throws CoreException 
	{
		return !variableName.equals(JavaRuntime.JRELIB_VARIABLE);
	}
}
