/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/

package org.eclipse.mtj.extension.smgmt.ui.actions;

import java.util.Iterator;
import java.util.List;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.smgmt.ui.SecurityManagmentUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

// public class Dialog implements IActionDelegate{
public class ContextMenuActivate implements IWorkbenchWindowActionDelegate {

	private IMtjProject fTargetProject = null;

	public void run(IAction arg0) {
		Shell shell;
		Display display = Display.getCurrent();
		if (display == null) {
			display = Display.getDefault();
		}
		if (display == null) {
			shell = new Shell();
		} else {
			shell = display.getActiveShell();
		}

		try {
			if (fTargetProject != null) {
				//If selected project has MIDP nature, display Security dialog, with project selected
				if (fTargetProject.getProjectData().getType() == ProjectType.PROJECT_TYPE_MIDP_LITERAL) {
					MainDialog Dlg = new MainDialog(shell, fTargetProject);
					Dlg.open();
				}
//				else {
//					//If not MIDP show error dialog, do not open security dialog
//				}
			} else { // ftargetproject == null
				MainDialog Dlg = new MainDialog(shell, null);
				Dlg.open();
			}

		} catch (MtjException e) {
			ErrorDialog.openError (	shell	
					, SecurityManagmentUIMessages.MidpSecurity_Title
					, SecurityManagmentUIMessages.ContextMenuActivate_0
					, new Status( IStatus.ERROR, IEclipseMtjCoreConstants.PLUGIN_ID, -1	, e.toString(), e)
					);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection && ((IStructuredSelection) selection).size() == 1) {		
			fTargetProject = getFirstProject(((IStructuredSelection) selection).toList());
		}
	}

	private IMtjProject getFirstProject(List list) {
		IMtjProject firstProject = null;
		for (Iterator i = list.iterator(); i.hasNext();) {
			Object element = i.next();
			
			if (element instanceof IAdaptable) {
				// any resource will trigger this action (for its project)
				IResource res = (IResource) ((IAdaptable) element).getAdapter(IResource.class);
				
				if (res != null) {
					try {
						//get an MTJ project from the selection
						firstProject = MtjProject.getMtjProject((new JavaProject(res.getProject(), null)));
					} catch (MtjException e) {}
				}
			}
		}
		return firstProject;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#dispose()
	 */
	public void dispose() {
		// Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IWorkbenchWindowActionDelegate#init(org.eclipse.ui.IWorkbenchWindow)
	 */
	public void init(IWorkbenchWindow arg0) {

		// Auto-generated method stub

	}

}
