/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IBM - initial API and implementation
 *******************************************************************************/
package org.eclipse.mtj.extension.smgmt.ui.utils;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;

public class SmgmtUtils {

	public static Object getSecurityManagementProviders(){
		
		MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.SECURITY_MANAGEMENT_LITERAL, null, null);
		SecurityManagement [] smgmtList = new SecurityManagement[list.length];
				
		for(int i = 0; i < list.length; i++){
			smgmtList[i] = (SecurityManagement)list[i];
		}
		
		return smgmtList;
	}

	public static Object getSecurityManagementProvidersList() throws MtjException{

		MtjExtension[] installedSMPINList = MtjServices.getInstance().getImplementations(ExtensionType.SECURITY_MANAGEMENT_LITERAL, null, null);
		
		SecurityManagement [] smlist = new SecurityManagement[installedSMPINList.length];

		for (int i = 0; i < installedSMPINList.length; i++){
			smlist[i] = (SecurityManagement)installedSMPINList[i];
		}
		//if (smlist.length <= 0){
		PersistentStoreProvider pstore = (PersistentStoreProvider) MtjServices
				.getInstance().getImplementations(
						ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, 
						null, null)[0];
		
		EList securityManagers = null;
		
		try {
		securityManagers = (EList) pstore.get(
				PersistentStoreProvider.DATA_TYPE_EMF, "securityManagers", //$NON-NLS-1$
				"org.eclipse.mtj.extension.smgmt.ui", "MtjSecurityManagers"); //$NON-NLS-1$ //$NON-NLS-2$
		} catch (MtjNotFoundException e) {
			//only throw this if smlist is empty
			if (smlist.length <= 0) {
				throw e;
			}
		}
		
		//If we got a list from the permanent storage provider,
		//compare it to the installed plug-ins list and
		//set active flags
		if (securityManagers != null) {
			for (int i = 0; i < securityManagers.size(); i++) {
				for (int j = 0; j < smlist.length; j++){
					if (smlist[j].getId().equals(((MtjExtension)securityManagers.get(i)).getId()))
					{
						smlist[j].setActive(((MtjExtension)securityManagers.get(i)).isActive());
					}
				}
			}
		}
		//}
		return smlist;
	}
	
	public static boolean storeSecurityManagers(Object securitymanagers){
		
		boolean storeOk = true;
		
		PersistentStoreProvider psp = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
		
		EList managers = null;
		
		if(securitymanagers instanceof SecurityManagement[]){
			
			managers = new BasicEList();

			
			SecurityManagement[] securityManagers = (SecurityManagement[])securitymanagers;
			
			for(int i = 0; i < securityManagers.length; i++){
				
				managers.add(securityManagers[i]);
			}
		}
		else if(securitymanagers instanceof EList){
			managers = (EList)securitymanagers;
		}
		
		try {
			psp.store(managers, PersistentStoreProvider.DATA_TYPE_EMF,
					"securityManagers", "org.eclipse.mtj.extension.smgmt.ui", "MtjSecurityManagers");  //$NON-NLS-1$//$NON-NLS-2$ //$NON-NLS-3$

		} catch (MtjException e) {
			storeOk = false;
		}
		
		return storeOk;
		
	}
}
