/**
 * Copyright (c) 2003-2004 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.core.project.midp.preverification;

import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;

/**
 * Abstract superclass of the preverification policies.
 * <p />
 * Copyright (c) 2003-2004 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:01 $
 * <br>
 * @author Craig Setera
 */
public abstract class AbstractPreverificationPolicy 
	implements IPreverificationPolicy 
{
	/**
	 * Construct a new policy instance.
	 * 
	 * @param traceEnabled
	 */
	public AbstractPreverificationPolicy() {
		super();
	}
	
	/**
	 * @see eclipseme.preverifier.IPreverificationPolicy#areFinalizersAllowed()
	 */
	public boolean areFinalizersAllowed() {
		return false;
	}

	/**
	 * @see eclipseme.preverifier.IPreverificationPolicy#areNativeMethodsAllowed()
	 */
	public boolean areNativeMethodsAllowed() {
		return false;
	}
}
