/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.smgmt.impl.j9;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.SecurityManagement;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.smgmt.impl.j9.J9SecurityManagerConstants;
import org.eclipse.mtj.extension.smgmt.impl.j9.Messages;
import org.eclipse.mtj.extension.smgmt.j9.J9SecurityPlugin;

public class J9SecurityManager
extends MtjExtensionImpl
implements SecurityManagement {
    private String storeType = "JKS";
    private String aliaskey = null;
    private String passwrd = null;
    private String keyStoreNameLoc = "";
    private String validity = "365";
    private IPreferenceStore securityProviderPrefStore;

    public J9SecurityManager() {
        this.setId(J9SecurityPlugin.getDefault().getBundle().getSymbolicName());
        this.setVendor(Messages.J9SecurityManager_PluginVendor);
        this.setVersion(Messages.J9SecurityManager_PluginVersion);
        this.setDescription(Messages.J9SecurityManager_Description);
        this.setType(ExtensionType.SECURITY_MANAGEMENT_LITERAL);
        this.securityProviderPrefStore = J9SecurityPlugin.getDefault().getPreferenceStore();
    }

    public String[] openKeyStore(String keyStore, String storePass, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.J9SecurityManager_Opening_keystore, 100);
        String[] cmdArgs = this.generateOpenKeyStoreCmd(keyStore, storePass);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        ArrayList<String> aliases = new ArrayList<String>();
        monitor.worked(50);
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") >= 0) {
                    monitor.done();
                    if (cmdOutput.toLowerCase().indexOf("Keystore password should have at least 6 characters") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20005)) + cmdOutput);
                    }
                    if (cmdOutput.toLowerCase().indexOf("Check the file path and password.") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20001)) + cmdOutput);
                    }
                    throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
                }
                if (cmdOutput.indexOf(",") < 0) continue;
                StringTokenizer strtok = new StringTokenizer(cmdOutput, ".,");
                aliases.add(strtok.nextToken());
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        monitor.worked(100);
        monitor.done();
        return aliases.toArray(new String[aliases.size()]);
    }

    public String getStoreType() throws MtjException {
        return this.storeType;
    }

    public String getAliaskey() throws MtjException {
        return this.aliaskey;
    }

    public String getPassWrd() throws MtjException {
        return this.passwrd;
    }

    public String getKeyStoreNameLoc() throws MtjException {
        return this.keyStoreNameLoc;
    }

    public String getValidity() throws MtjException {
        return this.validity;
    }

    public void setStoreType(String storeType) throws MtjException {
        this.storeType = storeType;
    }

    public void setAliaskey(String aliasKey) throws MtjException {
        this.aliaskey = aliasKey;
    }

    public void setPassWrd(String passWrd) throws MtjException {
        this.passwrd = passWrd;
    }

    public void setKeyStoreNameLoc(String keyStoreNameLoc) throws MtjException {
        this.keyStoreNameLoc = keyStoreNameLoc;
    }

    public void setValidity(String validity) throws MtjException {
        this.validity = validity;
    }

    public void setValues(String loc, String alias, String psswd, String strtype) throws MtjException {
        this.storeType = strtype;
        this.aliaskey = alias;
        this.passwrd = psswd;
        this.keyStoreNameLoc = loc;
    }

    private String[] generateOpenKeyStoreCmd(String keyStore, String storePasswd) throws MtjException {
        String[] openKeyStoreCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-list", "-storetype", this.storeType, "-keystore", keyStore, "-storepass", storePasswd};
        return openKeyStoreCmdArgs;
    }

    private final String getSecurityManagementTool() throws MtjException {
        String securityToolLocation = this.getToolLocation(null);
        if (securityToolLocation == null || securityToolLocation.length() <= 0 || securityToolLocation.equals(Messages.J9SecurityManager_Specify_directory_here)) {
            String message = MessageFormat.format(Messages.J9SecurityManager_getSecurityManagerException, this.getId(), Messages.J9SecurityManager_Tool_not_configured_correctly, Messages.J9SecurityManager_Using_Security_management_features);
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20003)) + "\n" + message);
        }
        StringBuffer buffer = new StringBuffer("\"");
        buffer.append(securityToolLocation).append(File.separator).append("bin").append(File.separator).append("keytool.exe").append("\"");
        return buffer.toString();
    }

    private static String getConsoleEncoding() {
        return "-J-Dconsole.encoding=" + System.getProperty("file.encoding");
    }

    private Process runSecurityCmd(String[] cmd) throws MtjException {
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(cmd, new String[0]);
        }
        catch (IOException iOException) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000));
        }
        if (p == null) {
            StringBuffer str = new StringBuffer("");
            int i = 0;
            while (i < cmd.length) {
                str.append(" " + cmd[i]);
                ++i;
            }
            throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + Messages.J9SecurityManager_Could_not_execute + " [" + str + "]");
        }
        return p;
    }

    public boolean isKeyStoreSelected() throws MtjException {
        return this.keyStoreNameLoc != null && this.keyStoreNameLoc.length() > 0;
    }

    public boolean importSignedCert(String certFile, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateImportSignedCertCmd(certFile);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateImportSignedCertCmd(String certFile) throws MtjException {
        String[] importSignedCertCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-import", "-noprompt", "-alias", this.aliaskey, "-keypass", this.passwrd, "-file", certFile, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return importSignedCertCmdArgs;
    }

    public boolean generateCSR(String certFile, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateGenerateCSRCmd(certFile);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateGenerateCSRCmd(String certFile) throws MtjException {
        String[] generateCSRCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-export", "-alias", this.aliaskey, "-file", certFile, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return generateCSRCmdArgs;
    }

    public boolean deleteKey(IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateDeleteKeyCmd();
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateDeleteKeyCmd() throws MtjException {
        String[] deleteKeyCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-delete", "-alias", this.aliaskey, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return deleteKeyCmdArgs;
    }

    public boolean changeStorePassword(String newStorePass, String storePass, IProgressMonitor monitor) throws MtjException {
        boolean cmdSuccessful = true;
        String[] cmdArgs = this.generateChangeStorePasswordCmd(newStorePass, storePass);
        Process p = this.runSecurityCmd(cmdArgs);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput;
            while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                if (cmdOutput.toLowerCase().indexOf("error") < 0) continue;
                throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        return cmdSuccessful;
    }

    private String[] generateChangeStorePasswordCmd(String newStorePass, String storePasswd) throws MtjException {
        String[] changeStorePasswordCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-storepasswd", "-new", newStorePass, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", storePasswd};
        return changeStorePasswordCmdArgs;
    }

    public boolean createNewKey(String alias, String commonName, String orgUnit, String orgName, String localityName, String stateName, String country, IProgressMonitor monitor) throws MtjException {
        monitor.beginTask(Messages.J9SecurityManager_Creating_key_alias, 100);
        boolean cmdSuccessful = true;
        String Dname = this.generateDname(commonName, orgUnit, orgName, localityName, stateName, country);
        String[] cmdArgs = this.generateNewKeyCmd(alias, Dname, "RSA", "SHA1withRSA");
        Process p = this.runSecurityCmd(cmdArgs);
        monitor.worked(10);
        BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
        try {
            String cmdOutput = cmdOutputStream.readLine();
            if (cmdOutput != null) {
                monitor.worked(40);
                if (cmdOutput.toLowerCase().indexOf("error") >= 0) {
                    monitor.done();
                    if (cmdOutput.toLowerCase().indexOf("keystore contains the given alias") >= 0) {
                        throw new MtjException(cmdOutput);
                    }
                    throw new MtjException(cmdOutput);
                }
            }
        }
        catch (IOException ee) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
        }
        monitor.worked(100);
        monitor.done();
        return cmdSuccessful;
    }

    private String[] generateNewKeyCmd(String alias, String dname, String keyAlg, String sigAlg) throws MtjException {
        String[] newKeyCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-genkey", "-v", "-alias", alias, "-dname", dname, "-keypass", this.passwrd, "-storetype", this.storeType, "-keyalg", keyAlg, "-sigalg", sigAlg, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd, "-validity", this.validity};
        return newKeyCmdArgs;
    }

    public String generateDname(String commonName, String orgUnit, String orgName, String localityName, String stateName, String country) {
        String Dname = "\"CN=" + commonName + ", " + "OU=" + orgUnit + ", " + "O=" + orgName + ", " + "L=" + localityName + ", " + "S=" + stateName + ", " + "C=" + country + "\"";
        return Dname;
    }

    public String getCertificateInfo(IProgressMonitor monitor) throws MtjException {
        String certInfo = "";
        if (this.aliaskey != null && this.aliaskey.length() > 0) {
            try {
                String cmdOutput;
                String[] cmdArgs = this.generateDisplayCertifcates();
                Process p = this.runSecurityCmd(cmdArgs);
                BufferedReader cmdOutputStream = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((cmdOutput = cmdOutputStream.readLine()) != null) {
                    if (cmdOutput.toLowerCase().indexOf("error") >= 0) {
                        throw new MtjException(String.valueOf(MtjCoreErrors.getErrorMessage((int)20000)) + " " + cmdOutput);
                    }
                    if (cmdOutput.length() < 0) continue;
                    certInfo = String.valueOf(certInfo) + cmdOutput;
                }
            }
            catch (IOException ee) {
                certInfo = "";
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)ee);
            }
            catch (Exception e) {
                certInfo = "";
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)20000), (Throwable)e);
            }
        }
        return certInfo;
    }

    private String[] generateDisplayCertifcates() throws MtjException {
        String[] listCertificateCmdArgs = new String[]{this.getSecurityManagementTool(), J9SecurityManager.getConsoleEncoding(), "-list", "-alias", this.aliaskey, "-storetype", this.storeType, "-keystore", this.keyStoreNameLoc, "-storepass", this.passwrd};
        return listCertificateCmdArgs;
    }

    public String getToolLocation(IProgressMonitor monitor) throws MtjException {
        return this.securityProviderPrefStore.getString(J9SecurityManagerConstants.SECURITY_TOOL_LOCATION);
    }

    public void storeToolLocation(String loc, IProgressMonitor monitor) throws MtjException {
        this.securityProviderPrefStore.setValue(J9SecurityManagerConstants.SECURITY_TOOL_LOCATION, loc);
    }

    public void resetValues() throws MtjException {
    }
}

