/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.preferences;

import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.dm.preferences.DevicePlatformListController;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListComposite;
import org.eclipse.mtj.extension.dm.ui.util.PreferenceUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DmPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String NOKIA_IMPORT_PROVIDER = "org.eclipse.mtj.extension.dpp.nokia";
    private static final String UEI_IMPORT_PROVIDER = "org.eclipse.mtj.extension.dpp.uei";
    private static Logger log = Logger.getLogger(DmPreferencePage.class.getName());
    private DevicePlatformListComposite deviceComposite;
    private DevicePlatformListController deviceController;

    public DmPreferencePage() {
        log.info(Messages.DmPreferencePage_ConstructingDmPreferencePage);
        this.setTitle(Messages.DmPreferencePage_DevicePlatform);
        this.setDescription(Messages.DmPreferencePage_CreateAndModifyDevicePlatforms);
    }

    protected Control createContents(Composite parent) {
        this.deviceComposite = new DevicePlatformListComposite(parent);
        this.deviceController = new DevicePlatformListController(this.deviceComposite);
        return this.deviceComposite;
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.DevicePlatformListController_Confirm, null, Messages.DmPreferencePage_ConfirmDescription, 3, new String[]{Messages.DevicePlatformListController_Ok, Messages.DevicePlatformListController_Cancel}, 0);
        if (dialog.open() == 0) {
            this.deviceController.setDefaults();
        }
    }

    private boolean storeDevicePlatforms(DevicePlatform[] devicePlatforms) {
        boolean okToStore = MtjServiceHandler.setDevicePlatforms(devicePlatforms);
        log.info("DMPreferencePage OK Performed " + okToStore);
        if (okToStore) {
            return super.performOk();
        }
        return okToStore;
    }

    public static DevicePlatformProvider getProvider(String id) {
        DevicePlatformProvider[] dpps;
        PreferenceUtils utils = new PreferenceUtils();
        DevicePlatformProvider[] devicePlatformProviderArray = dpps = utils.getToolkitSupporters();
        int n = 0;
        int n2 = devicePlatformProviderArray.length;
        while (n < n2) {
            DevicePlatformProvider dpp = devicePlatformProviderArray[n];
            if (dpp.getId().equals(id)) {
                return dpp;
            }
            ++n;
        }
        return null;
    }

    public boolean performOk() {
        DevicePlatform[] savePlatforms = this.deviceController.getDevicePlatforms() != null ? this.deviceController.getDevicePlatforms() : new DevicePlatform[]{};
        DevicePlatformProvider dpp = DmPreferencePage.getProvider(UEI_IMPORT_PROVIDER);
        try {
            ((ToolkitSupport)dpp).setDevicePlatforms(savePlatforms);
        }
        catch (MtjException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

