/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.jad.Messages;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.PropertyFile;

public class SynchronizeManifestFileToJad
implements IRunnableWithProgress {
    public static final IPath META_INFO_PATH = new Path("META-INF/MANIFEST.MF");
    private IFile fJadFile;
    private static final Set fRequiredManifestMidletKeys = new HashSet();
    private static final Set fManifestPrefixes;

    static {
        fRequiredManifestMidletKeys.add("MIDlet-Name");
        fRequiredManifestMidletKeys.add("MIDlet-Vendor");
        fRequiredManifestMidletKeys.add("MIDlet-Version");
        fRequiredManifestMidletKeys.add("MicroEdition-Profile");
        fRequiredManifestMidletKeys.add("MicroEdition-Configuration");
        fManifestPrefixes = new HashSet();
        fManifestPrefixes.add("MIDlet-");
        fManifestPrefixes.add("MicroEdition-");
    }

    public SynchronizeManifestFileToJad(IFile jadFile) {
        this.fJadFile = jadFile;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubProgressMonitor pm = new SubProgressMonitor(monitor, 5);
        try {
            try {
                IFile manifestFile;
                pm.beginTask(Messages.SynchronizeManifestFileToJad_UpdateInfoAction, 10);
                JadFileDescriptor descriptor = JadFileDescriptor.getDescriptor(this.fJadFile);
                IProject infoDir = SynchronizeManifestFileToJad.getMidletsInfoFolder(this.fJadFile);
                IFolder manifestDir = this.getManifestFileFolder();
                if (!manifestDir.exists()) {
                    manifestDir.create(true, true, (IProgressMonitor)pm);
                }
                if (!this.manifestFileIsUpToDate(manifestFile = this.getManifestFile(), descriptor)) {
                    PropertyFile manifestPropFile = new PropertyFile();
                    manifestPropFile.setProperty("Manifest-Version", "1.0");
                    manifestPropFile.setProperty("MicroEdition-Profile", descriptor.getProperty("MicroEdition-Profile"));
                    if (descriptor.isMidp20()) {
                        manifestPropFile.setProperty("MicroEdition-Configuration", descriptor.getProperty("MicroEdition-Configuration"));
                    } else {
                        manifestPropFile.setProperty("MicroEdition-Configuration", "CLDC-1.0");
                    }
                    if (manifestFile.exists()) {
                        manifestPropFile.loadInto(manifestFile, true);
                    }
                    HashSet<String> propertySet = new HashSet<String>();
                    propertySet.addAll(fRequiredManifestMidletKeys);
                    int i = 1;
                    while (i <= descriptor.getMIDletCount()) {
                        propertySet.add(JadFileDescriptor.getMIDletKey(i));
                        ++i;
                    }
                    descriptor.mergeInto(propertySet, manifestPropFile);
                    descriptor.updateManifest(propertySet, manifestPropFile);
                    manifestPropFile.serialize(manifestFile, (IProgressMonitor)pm);
                }
                IPath destination = infoDir.getFullPath().append(this.fJadFile.getName());
                IFile destFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destination);
                if (destFile.exists()) {
                    JadFileDescriptor destPropFile = JadFileDescriptor.getDescriptor(destFile);
                    PropertyFile origDestFile = (PropertyFile)((PropertyFile)destPropFile).clone();
                    if (!origDestFile.equals(descriptor.mergeInto(destPropFile))) {
                        descriptor.serialize(destFile, (IProgressMonitor)pm);
                    }
                } else {
                    this.fJadFile.copy(destination, true, (IProgressMonitor)pm);
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            pm.done();
        }
    }

    private static final String getSuiteName(IFile jadFile) {
        IPath jadPath = jadFile.getFullPath();
        return jadPath.removeFirstSegments(jadPath.segmentCount() - 1).removeFileExtension().toString();
    }

    public static IProject getMidletsInfoFolder(IFile jadFile) {
        IProject project = jadFile.getProject();
        return project;
    }

    private IFolder getManifestFileFolder() {
        IFolder folder = SynchronizeManifestFileToJad.getMidletsInfoFolder(this.fJadFile).getFolder(META_INFO_PATH.segment(0));
        return folder;
    }

    public IFile getManifestFile() {
        return this.getManifestFileFolder().getFile(META_INFO_PATH.segment(1));
    }

    private boolean manifestFileIsUpToDate(IFile manifestFile, JadFileDescriptor d) throws IOException, CoreException {
        String entryInManifest;
        String entryInJad;
        if (!manifestFile.exists()) {
            return false;
        }
        Map manifestMidletEntries = this.getMidletEntriesFromManifest(manifestFile);
        for (String reqKey : fRequiredManifestMidletKeys) {
            entryInJad = d.getProperty(reqKey);
            if (entryInJad == null || entryInJad.equals(entryInManifest = (String)manifestMidletEntries.get(reqKey))) continue;
            return false;
        }
        int index = 1;
        while (index <= d.getMIDletCount()) {
            entryInJad = d.getMIDlet(index).getValue();
            if (!entryInJad.equals(entryInManifest = (String)manifestMidletEntries.get(JadFileDescriptor.getMIDletKey(index)))) {
                return false;
            }
            ++index;
        }
        String forbiddenKey = JadFileDescriptor.getMIDletKey(d.getMIDletCount() + 1);
        return !manifestMidletEntries.containsKey(forbiddenKey);
    }

    private Map getMidletEntriesFromManifest(IFile manifestFile) throws IOException, CoreException {
        HashMap<String, String> result = new HashMap<String, String>();
        PropertyFile manifest = PropertyFile.load(manifestFile, false).prefixedSubset(fManifestPrefixes);
        Iterator i = manifest.keyIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!fRequiredManifestMidletKeys.contains(key) && !JadFileDescriptor.isMidletNrKey(key)) continue;
            result.put(key, manifest.getProperty(key));
        }
        return result;
    }
}

