/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.executable.uei;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.internal.utils.ColonDelimitedProperties;
import org.eclipse.mtj.internal.utils.Utils;

public class UeiPropertiesCache {
    public static final UeiPropertiesCache instance = new UeiPropertiesCache();
    public static final String PROP_TOOLKIT_NAME = "eclipse.mtj.toolkit.name";
    private static final String CACHE_DIRECTORY = "ueicache";
    private static final String CACHE_FILE = "cache.properties";
    private static final String PARM_XQUERY = "-Xquery";
    private Properties cacheMap;
    private Map propertiesMap = new HashMap();
    private IPath cachePath;
    private File cachePropertiesFile;

    private UeiPropertiesCache() {
    }

    public void clearCache(IProgressMonitor monitor) throws CoreException {
        File cacheDirFile;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if ((cacheDirFile = this.getCachePath().toFile()).exists()) {
            File[] files = cacheDirFile.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isFile() && file.getName().endsWith(".properties")) {
                    file.delete();
                }
                ++i;
            }
        }
    }

    public Properties getUEIProperties(File emulatorExecutable) throws CoreException {
        Properties properties = null;
        try {
            if (properties == null) {
                properties = Utils.executableExists((File)emulatorExecutable) ? this.getUEIProperties(UeiPropertiesCache.getEmulatorOutput(emulatorExecutable), UeiPropertiesCache.getToolkitName(emulatorExecutable), UeiPropertiesCache.getToolkitProfileAndConfiguration(emulatorExecutable)) : new Properties();
                this.addEmulatorPropertiesToCache(emulatorExecutable, properties);
            }
        }
        catch (IOException e) {
            MtjCorePlugin.throwCoreException((int)4, (int)-9999, (Throwable)e);
        }
        return properties;
    }

    public Properties getUEIProperties(String output, String toolkitName, Properties profileAndConf) throws CoreException, IOException {
        String tmp;
        Properties ueiProperties = UeiPropertiesCache.parseUEIPropertiesString(output);
        if (toolkitName != null && toolkitName.length() > 0) {
            ueiProperties.setProperty(PROP_TOOLKIT_NAME, toolkitName);
        }
        if ((tmp = profileAndConf.getProperty("Profile")) != null) {
            ueiProperties.setProperty("Profile", tmp);
        }
        if ((tmp = profileAndConf.getProperty("Configuration")) != null) {
            ueiProperties.setProperty("Configuration", tmp);
        }
        return ueiProperties;
    }

    private void addEmulatorPropertiesToCache(File emulatorExecutable, Properties properties) throws IOException {
        String path = emulatorExecutable.toString();
        File cacheDirectory = this.getCachePath().toFile();
        File cacheFile = File.createTempFile("emulator_", ".properties", cacheDirectory);
        FileOutputStream fos = new FileOutputStream(cacheFile);
        properties.store(fos, "Emulator properties for " + path);
        fos.close();
        Properties cache = this.getCacheMap();
        cache.put(path, cacheFile.getName());
        this.writeCache(cache);
    }

    private Properties getCachedProperties(File emulatorExecutable) throws IOException {
        String propsPath;
        String path = emulatorExecutable.getAbsolutePath();
        Properties properties = (Properties)this.propertiesMap.get(path);
        if (properties == null && (propsPath = this.getCacheMap().getProperty(path)) != null) {
            properties = this.readCachedProperties(emulatorExecutable, propsPath);
            this.propertiesMap.put(path, properties);
        }
        return properties;
    }

    private Properties getCacheMap() throws IOException {
        if (this.cacheMap == null) {
            this.cacheMap = this.readCache();
        }
        return this.cacheMap;
    }

    private IPath getCachePath() {
        if (this.cachePath == null) {
            IPath pluginStatePath = MtjCorePlugin.getDefault().getStateLocation();
            this.cachePath = pluginStatePath.append(CACHE_DIRECTORY);
            File cacheDirectory = this.cachePath.toFile();
            if (!cacheDirectory.exists()) {
                cacheDirectory.mkdir();
            }
        }
        return this.cachePath;
    }

    private File getCachePropertiesFile() {
        if (this.cachePropertiesFile == null) {
            this.cachePropertiesFile = this.getCachePath().append(CACHE_FILE).toFile();
            System.out.println("[INFO] MTJ: Reading emulator properties from cache file: " + this.getCachePath().append(CACHE_FILE).toString());
        }
        return this.cachePropertiesFile;
    }

    private static String getToolkitName(File executable) {
        String toolkitName = null;
        try {
            String[] commandLine = new String[]{executable.toString(), "-version"};
            String output = Utils.getStandardOutput((String)"UEI Emulator Version", (String[])commandLine);
            BufferedReader reader = new BufferedReader(new StringReader(output));
            toolkitName = reader.readLine();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        if (toolkitName == null) {
            toolkitName = "Generic UEI Toolkit";
        }
        return toolkitName;
    }

    private static Properties getToolkitProfileAndConfiguration(File executable) {
        Properties tmpProps = null;
        try {
            tmpProps = UeiPropertiesCache.parseUEIPropertiesString(UeiPropertiesCache.getEmulatorVersionOutput(executable));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (tmpProps == null) {
            tmpProps = new Properties();
        }
        return tmpProps;
    }

    private static String getEmulatorVersionOutput(File emulatorExecutable) throws CoreException {
        String[] commandLine = new String[]{emulatorExecutable.toString(), "-version"};
        return Utils.getStandardOutput((String)"UEI Emulator version", (String[])commandLine);
    }

    private static String getEmulatorOutput(File emulatorExecutable) throws CoreException {
        String[] commandLine = new String[]{emulatorExecutable.toString(), PARM_XQUERY};
        return Utils.getStandardOutput((String)"UEI Emulator Query", (String[])commandLine);
    }

    public static Properties parseUEIPropertiesString(String contents) throws IOException {
        ColonDelimitedProperties props = new ColonDelimitedProperties();
        StringReader reader = new StringReader(contents);
        try {
            props.load((Reader)reader);
        }
        catch (Exception e) {
            MtjCorePlugin.log((int)2, (String)"Error parsing UEI properties", (Throwable)e);
            MtjCorePlugin.log((int)2, (String)contents);
        }
        return props;
    }

    private Properties readCache() throws IOException {
        Properties properties = new Properties();
        File cacheFile = this.getCachePropertiesFile();
        if (cacheFile.exists()) {
            FileInputStream fis = new FileInputStream(cacheFile);
            properties.load(fis);
            fis.close();
        }
        return properties;
    }

    private Properties readCachedProperties(File emulatorExecutable, String propsPath) throws IOException {
        ColonDelimitedProperties properties = null;
        File file = this.getCachePath().append(propsPath).toFile();
        if (file.exists()) {
            if (file.lastModified() < emulatorExecutable.lastModified()) {
                file.delete();
            } else {
                properties = new ColonDelimitedProperties();
                FileInputStream fis = new FileInputStream(file);
                properties.load((InputStream)fis);
                fis.close();
            }
        }
        return properties;
    }

    private void writeCache(Properties properties) throws IOException {
        if (properties != null) {
            File cacheFile = this.getCachePropertiesFile();
            FileOutputStream fos = new FileOutputStream(cacheFile);
            properties.store(fos, "UEI Properties Cache");
            fos.close();
        }
    }
}

