/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dpp.uei;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IExecutablePlatform;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.launching.EmulatorRunner;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.MtjNotFoundException;
import org.eclipse.mtj.executable.uei.UeiExecutable;
import org.eclipse.mtj.extension.dm.preferences.DmPreferencePage;
import org.eclipse.mtj.extension.dpp.uei.Messages;

public abstract class AbstractUeiDevicePlatformProvider
extends MtjExtensionImpl
implements DevicePlatformProvider,
ToolkitSupport {
    public abstract DevicePlatformImporter getDevicePlatformImporter();

    public abstract String getPluginName();

    public DevicePlatform[] getDevicePlatforms() throws MtjException {
        try {
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            EList list = null;
            try {
                list = (EList)pstore.get(0, "devices", this.getPluginName(), "DevicePlatform");
            }
            catch (MtjNotFoundException mtjNotFoundException) {
                this.setDevicePlatforms(new DevicePlatform[0]);
                return new DevicePlatform[0];
            }
            DevicePlatform[] devicePlatforms = new DevicePlatform[list.size()];
            int i = 0;
            while (i < list.size()) {
                devicePlatforms[i] = (DevicePlatform)list.get(i);
                this.setRelativeFilePaths(devicePlatforms[i]);
                devicePlatforms[i].setDevicePlatformProvider((MtjExtension)this);
                ++i;
            }
            return devicePlatforms;
        }
        catch (MtjNotFoundException mtjNotFoundException) {
            return new DevicePlatform[0];
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public void verify(IFolder sourceFolder, IProgressMonitor monitor) throws MtjException {
    }

    public String getRootDirectory(DevicePlatform dp) throws MtjException {
        for (ConfigurationItem item : dp.getConfiguration().getItems()) {
            String d;
            if (!"directory".equals(item.getName()) || (d = item.getValue()) == null) continue;
            if ((d = d.replace('\\', '/')).endsWith("/")) {
                d = d.substring(0, d.length() - 1);
            }
            return d;
        }
        throw new MtjException(Messages.AbstractUeiDevicePlatformProvider_RootDirectoryNotDefined);
    }

    public void setRootDirectory(DevicePlatform dp, String directory) {
        ConfigurationItem item2;
        for (ConfigurationItem item2 : dp.getConfiguration().getItems()) {
            if (!"directory".equals(item2.getName())) continue;
            item2.setValue(directory);
            return;
        }
        item2 = DevicesFactory.eINSTANCE.createConfigurationItem();
        item2.setName("directory");
        item2.setValue(directory);
        dp.getConfiguration().getItems().add((Object)item2);
    }

    public DeviceStatus getStatus(Device device) throws MtjException {
        for (Device d : this.getDevicePlatforms()[0].getDevices()) {
            if (d.getName() == null || !d.getName().equals(device.getName())) continue;
            return DeviceStatus.DEVICE_STATUS_OK_LITERAL;
        }
        return DeviceStatus.DEVICE_STATUS_ERROR_LITERAL;
    }

    private void setRelativeFilePaths(DevicePlatform dp) throws MtjException {
        String root = this.getRootDirectory(dp);
        for (RuntimePlatformDefinition rpd : dp.getRuntimePlatformDefinitions()) {
            ImplementationRef ir;
            for (DeviceProfile dep : rpd.getDeviceProfiles()) {
                for (ServiceApi sa : dep.getServiceApis()) {
                    ImplementationRef ir2 = sa.getImplementation();
                    this.setRelativeFilePaths(ir2, root);
                }
            }
            for (ServiceApi sa : rpd.getServiceApis()) {
                ir = sa.getImplementation();
                this.setRelativeFilePaths(ir, root);
            }
            for (DeviceConfiguration dc : rpd.getDeviceConfigurations()) {
                ir = dc.getImplementation();
                this.setRelativeFilePaths(ir, root);
            }
        }
    }

    private void setRelativeFilePaths(ImplementationRef ir, String root) throws MtjException {
        ir.setFileRef(this.setRelativeFilePaths(ir.getFileRef(), root));
        ir.setJavadocRef(this.setRelativeFilePaths(ir.getJavadocRef(), root));
        ir.setSourceRef(this.setRelativeFilePaths(ir.getSourceRef(), root));
    }

    private String setRelativeFilePaths(String path, String root) throws MtjException {
        if (path == null) {
            return path;
        }
        String r = path.replace('\\', '/');
        if (r.startsWith("/")) {
            r = String.valueOf(root) + r;
        }
        return r;
    }

    private void setAbsoluteFilePaths(DevicePlatform dp) throws MtjException {
        String root = this.getRootDirectory(dp);
        for (RuntimePlatformDefinition rpd : dp.getRuntimePlatformDefinitions()) {
            ImplementationRef ir;
            for (DeviceProfile dep : rpd.getDeviceProfiles()) {
                for (ServiceApi sa : dep.getServiceApis()) {
                    ImplementationRef ir2 = sa.getImplementation();
                    this.setAbsoluteFilePaths(ir2, root);
                }
            }
            for (ServiceApi sa : rpd.getServiceApis()) {
                ir = sa.getImplementation();
                this.setAbsoluteFilePaths(ir, root);
            }
            for (DeviceConfiguration dc : rpd.getDeviceConfigurations()) {
                ir = dc.getImplementation();
                this.setAbsoluteFilePaths(ir, root);
            }
        }
    }

    private void setAbsoluteFilePaths(ImplementationRef ir, String root) throws MtjException {
        ir.setFileRef(this.setAbsoluteFilePaths(ir.getFileRef(), root));
        ir.setJavadocRef(this.setAbsoluteFilePaths(ir.getJavadocRef(), root));
        ir.setSourceRef(this.setAbsoluteFilePaths(ir.getSourceRef(), root));
    }

    private String setAbsoluteFilePaths(String path, String root) throws MtjException {
        if (path == null) {
            return path;
        }
        String r = path.replace('\\', '/');
        if (r.startsWith(root)) {
            r = r.substring(root.length());
        }
        return r;
    }

    public void launch(DevicePlatform dp, Device device, Deployment deployment, VMRunnerConfiguration vmRunnerConfig, ILaunchConfiguration launchConfig, ILaunch launch, String runMode, String projectNatureId, IProgressMonitor monitor) throws MtjException {
        UeiExecutable executablePlatform = new UeiExecutable(dp, device);
        EmulatorRunner emulatorRunner = new EmulatorRunner(dp, (IExecutablePlatform)executablePlatform, runMode);
        try {
            emulatorRunner.run(vmRunnerConfig, launchConfig, deployment, launch, projectNatureId, device, monitor);
        }
        catch (CoreException e) {
            throw new MtjException((Throwable)e);
        }
        catch (MtjException e) {
            throw e;
        }
    }

    public void setDevicePlatforms(DevicePlatform[] dps) throws MtjException {
        BasicEList list = new BasicEList();
        try {
            int i = 0;
            while (i < dps.length) {
                this.setAbsoluteFilePaths(dps[i]);
                dps[i].setDevicePlatformProvider(null);
                list.add((Object)dps[i]);
                ++i;
            }
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            pstore.store((Object)list, 0, "devices", this.getPluginName(), "DevicePlatform");
            int i2 = 0;
            while (i2 < dps.length) {
                this.setRelativeFilePaths(dps[i2]);
                dps[i2].setDevicePlatformProvider((MtjExtension)this);
                ++i2;
            }
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)513), (Throwable)ex);
        }
    }

    public PreferencePage getPreferencePage() {
        return new DmPreferencePage();
    }
}

