/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.extension.preverify.Messages;
import org.eclipse.mtj.extension.preverify.PreverificationResults;
import org.eclipse.mtj.extension.preverify.internal.PreverificationClassNode;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ClassPreverifier {
    private IPreverificationPolicy preverificationPolicy;

    public ClassPreverifier(IPreverificationPolicy preverificationPolicy) {
        this.preverificationPolicy = preverificationPolicy;
    }

    public PreverificationResults preverify(InputStream classStream, URL[] classpath) throws IOException {
        URLClassLoader classLoader = new URLClassLoader(classpath, Thread.currentThread().getContextClassLoader());
        return this.preverify(classStream, classLoader);
    }

    public PreverificationResults preverify(InputStream classStream, ClassLoader classloader) throws IOException {
        if (classStream == null) {
            throw new IllegalArgumentException(Messages.ClassPreverifier_ClassByteStreamNotNull);
        }
        PreverificationClassNode classNode = new PreverificationClassNode(this.preverificationPolicy, classloader);
        ClassReader classReader = new ClassReader(classStream);
        classReader.accept((ClassVisitor)classNode, false);
        classStream.close();
        List errorList = classNode.getErrorList();
        PreverificationError[] errorArray = errorList.toArray(new PreverificationError[errorList.size()]);
        PreverificationResults results = null;
        if (errorArray.length > 0) {
            results = new PreverificationResults(null, null, errorArray);
        } else {
            ClassWriter classWriter = new ClassWriter(false);
            classNode.accept((ClassVisitor)classWriter);
            byte[] bytecode = classWriter.toByteArray();
            results = new PreverificationResults(classNode, bytecode, errorArray);
        }
        return results;
    }
}

