/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.TraceClassVisitor;

public class PreverificationResults {
    private ClassNode preverifiedClassNode;
    private byte[] preverifiedClassBytes;
    private PreverificationError[] errors;

    public PreverificationResults(ClassNode preverifiedClassNode, byte[] preverifiedClassBytes, PreverificationError[] errors) {
        this.preverifiedClassNode = preverifiedClassNode;
        this.preverifiedClassBytes = preverifiedClassBytes;
        this.errors = errors;
    }

    public PreverificationError[] getErrors() {
        return this.errors;
    }

    public byte[] getPreverifiedClassBytes() {
        return this.preverifiedClassBytes;
    }

    public ClassNode getPreverifiedClassNode() {
        return this.preverifiedClassNode;
    }

    public String getDisassembledOutput() {
        String traceOutput = null;
        if (this.errors.length == 0) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            TraceClassVisitor traceVisitor = new TraceClassVisitor(printWriter);
            this.preverifiedClassNode.accept((ClassVisitor)traceVisitor);
            printWriter.close();
            traceOutput = stringWriter.toString();
        }
        return traceOutput;
    }

    public boolean isErrorResult() {
        return this.errors.length > 0;
    }
}

