/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.utils;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class InputValidationDialog
extends Dialog {
    private IInputValidator validator2;
    private IInputValidator validator1;
    private IInputValidator validator;
    private String title;
    private String message;
    private String message1;
    private String message2;
    private String value = "";
    private Button okButton;
    private Text text;
    private Text text1;
    private Text text2;
    private String pass;
    private String pass1;
    private String pass2;
    private Label errorMessageLabel;
    private boolean enableok;

    public InputValidationDialog(Shell parentShell, String dialogTitle, String dialogMessage, String dialogMessage1, String dialogMessage2, IInputValidator validator, IInputValidator validator1, IInputValidator validator2) {
        super(parentShell);
        this.title = dialogTitle;
        this.validator = validator;
        this.validator1 = validator1;
        this.validator2 = validator2;
        this.message = dialogMessage;
        this.message1 = dialogMessage1;
        this.message2 = dialogMessage2;
        this.enableok = false;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.message != null) {
                this.setPass(this.text.getText());
            }
            if (this.message1 != null) {
                this.setPass1(this.text1.getText());
            }
            if (this.message2 != null) {
                this.setPass2(this.text2.getText());
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(final Composite parent) {
        GridData data;
        Label label;
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            label = new Label(composite, 64);
            label.setText(this.message);
            data = new GridData(1796);
            data.widthHint = 200;
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.text = new Text(composite, 2052);
            this.text.setLayoutData((Object)new GridData(768));
            if (this.message.compareTo("dd") != 0) {
                this.text.setEchoChar('*');
            }
            this.text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (InputValidationDialog.this.message1 == null) {
                        InputValidationDialog.this.enableok = true;
                    }
                    InputValidationDialog.this.validateInput(InputValidationDialog.this.validator, InputValidationDialog.this.text, parent);
                }
            });
        }
        if (this.message1 != null) {
            label = new Label(composite, 64);
            label.setText(this.message1);
            data = new GridData(1796);
            data.widthHint = 200;
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.text1 = new Text(composite, 2052);
            this.text1.setLayoutData((Object)new GridData(768));
            this.text1.setEchoChar('*');
            this.text1.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (InputValidationDialog.this.message2 == null) {
                        InputValidationDialog.this.enableok = true;
                    }
                    InputValidationDialog.this.validateInput(InputValidationDialog.this.validator1, InputValidationDialog.this.text1, parent);
                }
            });
        }
        if (this.message2 != null) {
            label = new Label(composite, 64);
            label.setText(this.message2);
            data = new GridData(1796);
            data.widthHint = 200;
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.text2 = new Text(composite, 2052);
            this.text2.setLayoutData((Object)new GridData(768));
            this.text2.setEchoChar('*');
            this.text2.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputValidationDialog.this.enableok = true;
                    InputValidationDialog.this.validateInput(InputValidationDialog.this.validator2, InputValidationDialog.this.text2, parent);
                }
            });
        }
        this.errorMessageLabel = new Label(composite, 64);
        GridData msg = new GridData(768);
        msg.heightHint = 35;
        this.errorMessageLabel.setLayoutData((Object)msg);
        this.errorMessageLabel.setFont(parent.getFont());
        return composite;
    }

    protected Label getErrorMessageLabel() {
        return this.errorMessageLabel;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    protected void validateInput(IInputValidator validator, Text text, Composite parent) {
        String errorMessage = null;
        if (validator != null) {
            errorMessage = validator.isValid(text.getText());
        }
        this.errorMessageLabel.setText(errorMessage == null ? "" : errorMessage);
        Color red = new Color((Device)parent.getShell().getDisplay(), 255, 0, 0);
        this.errorMessageLabel.setForeground(red);
        this.okButton.setEnabled(errorMessage == null && this.enableok);
        this.errorMessageLabel.getParent().update();
    }

    public String getPass() {
        return this.pass;
    }

    public String getPass1() {
        return this.pass1;
    }

    public String getPass2() {
        return this.pass2;
    }

    public void setPass(String string) {
        this.pass = string;
    }

    public void setPass1(String string) {
        this.pass1 = string;
    }

    public void setPass2(String string) {
        this.pass2 = string;
    }
}

