/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.ota;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.internal.ota.OTAHandler;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.handler.NotFoundHandler;
import org.mortbay.util.Log;
import org.mortbay.util.LogSink;
import org.mortbay.util.MultiException;
import org.mortbay.util.OutputStreamLogSink;

public class OTAServer {
    public static final OTAServer instance = new OTAServer();
    private HttpServer httpServer;

    public static int getPort() {
        HttpListener listener = instance.getHttpServer().getListeners()[0];
        return listener.getPort();
    }

    private OTAServer() {
    }

    public void start() throws MultiException {
        HttpServer server = this.getHttpServer();
        if (!server.isStarted()) {
            server.start();
        }
    }

    public void stop() throws InterruptedException {
        HttpServer server = this.getHttpServer();
        if (server.isStarted()) {
            server.stop();
        }
    }

    private void configureContext(HttpServer server) {
        HttpContext context = new HttpContext();
        context.setContextPath("/ota/*");
        server.addContext(context);
        context.addHandler((HttpHandler)new OTAHandler());
        context.addHandler((HttpHandler)new NotFoundHandler());
    }

    private void configureListener(HttpServer server) {
        SocketListener listener = new SocketListener();
        listener.setMinThreads(1);
        listener.setMaxThreads(2);
        listener.setMaxIdleTimeMs(10000);
        listener.setDaemon(true);
        Preferences prefs = MtjCorePlugin.getDefault().getPluginPreferences();
        if (prefs.getBoolean("ota_port_defined")) {
            int specifiedPortNumber = prefs.getInt("ota_port");
            listener.setPort(specifiedPortNumber);
        }
        server.addListener((HttpListener)listener);
    }

    private void configureLogging() throws CoreException {
        System.setProperty("LOG_FILE_RETAIN_DAYS", "5");
        IPath stateLocation = MtjCorePlugin.getDefault().getStateLocation();
        IPath logDirectory = stateLocation.append("jetty");
        File logDirectoryFile = logDirectory.toFile();
        if (!logDirectoryFile.exists()) {
            logDirectoryFile.mkdir();
        }
        File logFile = new File(logDirectoryFile, "logfile");
        String filename = logFile + "yyyy_mm_dd.txt";
        OutputStreamLogSink sink = new OutputStreamLogSink(filename);
        sink.start();
        Log.instance().add((LogSink)sink);
    }

    private HttpServer createHttpServer() {
        HttpServer server = new HttpServer();
        this.configureListener(server);
        this.configureContext(server);
        return server;
    }

    private HttpServer getHttpServer() {
        if (this.httpServer == null) {
            this.httpServer = this.createHttpServer();
            try {
                this.configureLogging();
            }
            catch (CoreException e) {
                MtjCorePlugin.log(2, "configureLogging", e);
            }
        }
        return this.httpServer;
    }
}

