/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.util;

import java.io.File;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.model.CdcDeployment;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.model.OsgiAwareMidletDeployment;
import org.eclipse.mtj.api.model.ResourceDeployment;
import org.eclipse.mtj.core.Messages;
import org.eclipse.mtj.core.util.DirUtil;
import org.eclipse.mtj.exception.MtjException;

public class CoreUtil {
    public static Deployment createDeployment(File[] resources, DeploymentType deploymentType) throws MtjException {
        if (deploymentType == DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL) {
            return CoreUtil.createMidletDeployment(resources);
        }
        if (deploymentType == DeploymentType.DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL) {
            return CoreUtil.createOsgiDeployment(resources);
        }
        if (deploymentType == DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL) {
            return CoreUtil.createCdcDeployment(resources);
        }
        if (deploymentType == DeploymentType.DEPLOYMENT_TYPE_RESOURCE_LITERAL) {
            return CoreUtil.createResourceDeployment(resources);
        }
        return null;
    }

    private static Deployment createOsgiDeployment(File[] resources) throws MtjException {
        String msg = Messages.CoreUtil_FileArrayMustContainOnlyOneBundle;
        if (resources.length != 1) {
            throw new MtjException(msg);
        }
        OsgiAwareMidletDeployment o = new OsgiAwareMidletDeployment();
        o.setType(DeploymentType.DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL);
        o.setBundle(resources[0]);
        return o;
    }

    private static Deployment createCdcDeployment(File[] resources) throws MtjException {
        String msg = Messages.CoreUtil_FileArrayMustBeJarFIles;
        int i = 0;
        while (i < resources.length) {
            if (!DirUtil.getFileExtension(resources[i].getName()).equalsIgnoreCase("jar")) {
                throw new MtjException(msg);
            }
            ++i;
        }
        CdcDeployment c = new CdcDeployment();
        c.setType(DeploymentType.DEPLOYMENT_TYPE_CDC_LITERAL);
        c.setJars(resources);
        return c;
    }

    private static Deployment createResourceDeployment(File[] resources) throws MtjException {
        ResourceDeployment rd = new ResourceDeployment();
        rd.setType(DeploymentType.DEPLOYMENT_TYPE_RESOURCE_LITERAL);
        rd.setResources(resources);
        return rd;
    }

    private static Deployment createMidletDeployment(File[] resources) throws MtjException {
        String msg = Messages.CoreUtil_FileArrayMustContainJarAndJadLocations;
        if (resources.length != 2) {
            throw new MtjException(msg);
        }
        if (!DirUtil.getFileExtension(resources[0].getName()).equalsIgnoreCase("jar")) {
            throw new MtjException(msg);
        }
        if (!DirUtil.getFileExtension(resources[1].getName()).equalsIgnoreCase("jad")) {
            throw new MtjException(msg);
        }
        MidletDeployment md = new MidletDeployment();
        md.setType(DeploymentType.DEPLOYMENT_TYPE_MIDLET_LITERAL);
        md.setJar(resources[0]);
        md.setJad(resources[1]);
        return md;
    }
}

