/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.PreverificationProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.preverify.ClassPreverifier;
import org.eclipse.mtj.extension.preverify.Messages;
import org.eclipse.mtj.extension.preverify.PreverificationResults;
import org.eclipse.mtj.extension.preverify.PreverifierPlugin;
import org.osgi.framework.Bundle;

public class PreverificationProviderImpl
extends MtjExtensionImpl
implements PreverificationProvider {
    private ClassPreverifier classPreverifier = null;
    private IPreverificationPolicy preverificationPolicy = null;

    public PreverificationProviderImpl() {
        this.setId(PreverifierPlugin.getDefault().getBundle().getSymbolicName());
        this.setDescription(Messages.PreverificationProviderImpl_PluginDescription);
        this.setVendor(Messages.PreverificationProviderImpl_PluginVendor);
        this.setVersion(Messages.PreverificationProviderImpl_PluginVersion);
        this.setType(ExtensionType.PREVERIFICATION_PROVIDER_LITERAL);
    }

    public PreverificationError[] preverify(IMtjProject project, RuntimePlatformDefinition targetPlatform, IResource[] resource, IFolder outputFolder, IProgressMonitor monitor) throws MtjException {
        ArrayList errorList = new ArrayList();
        try {
            int i = 0;
            while (i < resource.length) {
                if (resource[i] instanceof IContainer) {
                    this.preverify(project, targetPlatform, (IContainer)resource[i], outputFolder, errorList, monitor);
                } else {
                    this.preverify(project, targetPlatform, (IFile)resource[i], outputFolder, errorList, monitor);
                }
                ++i;
            }
            return errorList.toArray(new PreverificationError[errorList.size()]);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)10001), (Throwable)ex);
        }
    }

    public PreverificationError[] preverifyJarFile(String projectName, RuntimePlatformDefinition targetPlatform, File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws MtjException {
        return null;
    }

    private void preverify(IMtjProject project, RuntimePlatformDefinition targetPlatform, IContainer container, IFolder outputFolder, List errorList, IProgressMonitor monitor) throws MtjException, CoreException, IOException {
        IResource[] resources = null;
        try {
            resources = container.members();
        }
        catch (Exception exception) {
            return;
        }
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource.getType() == 2) {
                IFolder folder = (IFolder)resource;
                this.preverify(project, targetPlatform, (IContainer)folder, outputFolder, errorList, monitor);
            } else {
                IFile file = (IFile)resource;
                this.preverify(project, targetPlatform, file, outputFolder, errorList, monitor);
            }
            ++i;
        }
    }

    private void preverify(IMtjProject project, RuntimePlatformDefinition targetPlatform, IFile file, IFolder outputFolder, List errorList, IProgressMonitor monitor) throws MtjException, CoreException, IOException {
        URL[] classpath;
        InputStream contentStream;
        ClassPreverifier classPreverifier = this.getClassPreverifier(project, targetPlatform);
        PreverificationResults results = classPreverifier.preverify(contentStream = file.getContents(), classpath = this.getClasspath(project));
        if (results.isErrorResult()) {
            errorList.addAll((Collection)Arrays.asList(results.getErrors()));
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(results.getPreverifiedClassBytes());
            IFolder packageFolder = this.createPackageFolder(outputFolder, results, monitor);
            IFile outputFile = packageFolder.getFile(file.getName());
            if (!outputFile.exists()) {
                outputFile.create((InputStream)is, true, monitor);
            } else {
                outputFile.setContents((InputStream)is, true, false, monitor);
            }
        }
    }

    private IFolder createPackageFolder(IFolder outputFolder, PreverificationResults results, IProgressMonitor monitor) throws CoreException {
        String typeName = results.getPreverifiedClassNode().name;
        String[] components = typeName.split("/");
        IFolder currentFolder = outputFolder;
        int i = 0;
        while (i < components.length - 1) {
            String component = components[i];
            if (!(currentFolder = currentFolder.getFolder(component)).exists()) {
                currentFolder.create(true, true, monitor);
            }
            ++i;
        }
        return currentFolder;
    }

    private ClassPreverifier getClassPreverifier(IMtjProject project, RuntimePlatformDefinition targetPlatform) throws MtjException, CoreException {
        if (this.classPreverifier == null) {
            this.classPreverifier = new ClassPreverifier(this.getPreverificationPolicy(project, targetPlatform));
        }
        return this.classPreverifier;
    }

    protected IPreverificationPolicy getPreverificationPolicy(IMtjProject project, RuntimePlatformDefinition targetPlatform) throws MtjException, CoreException {
        if (this.preverificationPolicy == null) {
            this.preverificationPolicy = project.getPreverificationPolicy(targetPlatform);
        }
        return this.preverificationPolicy;
    }

    protected URL[] getClasspath(IMtjProject project) throws MtjException, CoreException, IOException {
        IJavaProject javaProject = project.getJavaProject();
        String[] entries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        URL[] classpath = new URL[entries.length + 1];
        classpath[0] = this.getEmptyAPI();
        int i = 0;
        while (i < entries.length) {
            File file = new File(entries[i]);
            classpath[i + 1] = file.toURL();
            ++i;
        }
        return classpath;
    }

    protected URL getEmptyAPI() throws IOException {
        Bundle bundle = PreverifierPlugin.getDefault().getBundle();
        URL emptyapi = bundle.getEntry("lib/emptyapi.zip");
        return FileLocator.resolve((URL)emptyapi);
    }
}

