/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mtj.jad.util.ConvertNativeToUTF8;
import org.eclipse.mtj.jad.util.PropertyLine;

public class PropertyFile {
    private static final int KEYS = 0;
    private static final int VALUES = 1;
    private static final int COMMENTS = 2;
    private boolean removingMidlets = true;
    private static final String[] digitSet = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    private List contents = new ArrayList();
    private Map lookupMap = new HashMap();

    protected Iterator lineIterator() {
        return this.contents.iterator();
    }

    public Iterator keyIterator() {
        return new PropertyFileIterator(0);
    }

    public Set keySet() {
        HashSet<String> set = new HashSet<String>();
        Iterator i = this.keyIterator();
        while (i.hasNext()) {
            set.add((String)i.next());
        }
        return set;
    }

    public Iterator valueIterator() {
        return new PropertyFileIterator(1);
    }

    public Iterator commentIterator() {
        return new PropertyFileIterator(2);
    }

    public int size() {
        return this.contents.size();
    }

    public void clear() {
        this.contents.clear();
        this.lookupMap.clear();
    }

    public void removeProperty(String key) {
        PropertyLine lineToRemove = (PropertyLine)this.lookupMap.remove(key);
        if (lineToRemove != null) {
            Iterator i = this.lineIterator();
            while (i.hasNext()) {
                PropertyLine line = (PropertyLine)i.next();
                if (lineToRemove != line) continue;
                i.remove();
                break;
            }
        }
    }

    public void setProperty(String key, String value, String comment) {
        if (key == null || value == null) {
            throw new IllegalArgumentException();
        }
        PropertyLine line = new PropertyLine();
        line.setKey(key);
        line.setValue(value);
        if (comment != null && comment.length() > 0) {
            if (!comment.startsWith("#")) {
                comment = "#" + comment;
            }
            line.setLeadingComment(comment);
        }
        this.setPropertyLine(line);
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, null);
    }

    protected void setPropertyLine(PropertyLine line) {
        int index = this.indexOf(line.key);
        if (index == this.contents.size()) {
            this.contents.add(line);
        } else {
            this.contents.set(index, line);
        }
        if (line.getKey() != null) {
            this.lookupMap.put(line.getKey(), line);
        }
    }

    private int indexOf(String key) {
        int indexOf = 0;
        if (key == null) {
            indexOf = this.contents.size();
        } else {
            indexOf = this.contents.size();
            int i = 0;
            while (i < this.contents.size()) {
                PropertyLine line = (PropertyLine)this.contents.get(i);
                if (line.getKey().equals(key)) {
                    indexOf = i;
                    break;
                }
                ++i;
            }
        }
        return indexOf;
    }

    public boolean containsProperty(String key) {
        return this.getProperty(key) != null;
    }

    public boolean containsAll(Set keys) {
        return this.lookupMap.keySet().containsAll(keys);
    }

    public PropertyFile prefixedSubset(Set keyPrefixSet) {
        PropertyFile subset = new PropertyFile();
        Iterator i = this.keyIterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            for (String keyPrefix : keyPrefixSet) {
                if (!key.startsWith(keyPrefix)) continue;
                subset.setProperty(key, this.getProperty(key), this.getComment(key));
            }
        }
        return subset;
    }

    public String getProperty(String key) {
        PropertyLine line = this.getPropertyLine(key);
        return line == null ? null : line.getValue();
    }

    public String getPropertyLineString(String key) {
        PropertyLine line = this.getPropertyLine(key);
        return line == null ? null : line.toString();
    }

    public String getComment(String key) {
        PropertyLine line = this.getPropertyLine(key);
        return line == null ? null : line.getLeadingComment();
    }

    protected PropertyLine getPropertyLine(String key) {
        return (PropertyLine)this.lookupMap.get(key);
    }

    public static PropertyFile load(IFile file, boolean retainComments) throws CoreException, IOException {
        return PropertyFile.load(file.getContents(), retainComments);
    }

    public static PropertyFile load(InputStream stream, boolean retainComments) throws IOException {
        return PropertyFile.load(new BufferedReader(new InputStreamReader(stream, "utf8")), retainComments);
    }

    public static PropertyFile load(BufferedReader reader, boolean retainComments) throws IOException {
        PropertyFile fileContents = new PropertyFile();
        fileContents.loadInto(reader, retainComments);
        return fileContents;
    }

    public void loadInto(IFile file, boolean retainComments) throws CoreException, IOException {
        this.loadInto(file.getContents(), retainComments);
    }

    public void loadInto(InputStream stream, boolean retainComments) throws IOException {
        this.loadInto(new BufferedReader(new InputStreamReader(stream, "utf8")), retainComments);
    }

    public void loadInto(BufferedReader reader, boolean retainComments) throws IOException {
        PropertyLine propLine = new PropertyLine();
        String line = reader.readLine();
        while (line != null) {
            if (line.equals("") || line.startsWith("#")) {
                if (retainComments) {
                    propLine.appendToLeadingComments(line);
                    propLine.appendToLeadingComments("\n");
                }
            } else {
                String[] tokenizedLine = PropertyFile.tokenizeLine(line);
                propLine.setKey(tokenizedLine[0]);
                propLine.setValue(tokenizedLine[1]);
                this.setPropertyLine(propLine);
                propLine = new PropertyLine();
            }
            line = reader.readLine();
        }
        if (propLine.getLeadingCommentLength() > 0) {
            this.setPropertyLine(propLine);
        }
        reader.close();
    }

    public void serialize(IFile file, IProgressMonitor monitor) throws CoreException, IOException {
        ByteArrayOutputStream slaveBytes = new ByteArrayOutputStream();
        int numProps = this.size();
        monitor.beginTask("", numProps + 1);
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, numProps);
        this.serialize(slaveBytes, (IProgressMonitor)subMonitor);
        ByteArrayInputStream slaveStream = new ByteArrayInputStream(slaveBytes.toByteArray());
        InputStream is = ConvertNativeToUTF8.convertNativeToUTF8(slaveStream);
        if (file.exists()) {
            file.setContents(is, true, true, monitor);
        } else {
            file.create(is, true, monitor);
        }
        monitor.worked(1);
        monitor.done();
    }

    public void serialize(OutputStream slaveStream, IProgressMonitor monitor) throws IOException {
        PrintWriter slaveWriter = new PrintWriter(slaveStream);
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            PropertyLine line = (PropertyLine)i.next();
            if (line.getLeadingCommentLength() > 0) {
                slaveWriter.print(line.getLeadingComment());
            }
            if (line.key != null) {
                slaveWriter.print(line.getKey());
                slaveWriter.print(": ");
                slaveWriter.print(ConvertNativeToUTF8.convertNativeToUTF8(line.getValue()));
                slaveWriter.println();
            }
            monitor.worked(1);
        }
        slaveWriter.flush();
    }

    public InputStream serialize() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.serialize(stream, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (IOException iOException) {}
        ByteArrayInputStream bais = new ByteArrayInputStream(stream.toByteArray());
        InputStream is = ConvertNativeToUTF8.convertNativeToUTF8(bais);
        return is;
    }

    public PropertyFile mergeInto(PropertyFile slave) throws CoreException, IOException {
        return this.mergeInto(this.lookupMap.keySet(), slave);
    }

    public PropertyFile mergeInto(Set keys, PropertyFile slave) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            PropertyLine line = (PropertyLine)i.next();
            if (!keys.contains(line.getKey())) continue;
            slave.mergeLine(line);
        }
        return slave;
    }

    public PropertyFile updateManifest(Set keys, PropertyFile slave) {
        if (keys == null) {
            throw new IllegalArgumentException();
        }
        HashSet digits = new HashSet(Arrays.asList(digitSet));
        this.setRemovingMidlets(true);
        block0: while (this.isRemovingMidlets()) {
            Iterator j = slave.lineIterator();
            while (j.hasNext()) {
                String digit1;
                this.setRemovingMidlets(false);
                PropertyLine line = null;
                line = (PropertyLine)j.next();
                if (keys.contains(line.getKey()) || !line.getKey().startsWith("MIDlet-") || !digits.contains(digit1 = new String(line.getKey().substring(7, 8)))) continue;
                slave.removeProperty(line.getKey());
                this.setRemovingMidlets(true);
                continue block0;
            }
        }
        return slave;
    }

    protected void mergeLine(PropertyLine masterLine) {
        PropertyLine slaveLine = this.getPropertyLine(masterLine.key);
        if (slaveLine != null) {
            slaveLine.value = masterLine.value;
        } else {
            this.setPropertyLine((PropertyLine)masterLine.clone());
        }
    }

    public static String[] tokenizeLine(String line) throws IllegalArgumentException {
        String[] tokenizedLine = new String[2];
        int i = line.indexOf(58);
        if (i > 0) {
            tokenizedLine[0] = line.substring(0, i);
            tokenizedLine[1] = "";
            ++i;
            while (i < line.length() && line.charAt(i) == ' ') {
                ++i;
            }
        } else {
            throw new IllegalArgumentException();
        }
        tokenizedLine[1] = i == line.length() ? "" : line.substring(i);
        return tokenizedLine;
    }

    public Object clone() {
        PropertyFile clone = new PropertyFile();
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            PropertyLine line = (PropertyLine)i.next();
            clone.setPropertyLine((PropertyLine)line.clone());
        }
        return clone;
    }

    public boolean equals(Object o) {
        boolean equals = false;
        if (o instanceof PropertyFile) {
            PropertyFile otherFile = (PropertyFile)o;
            if (this.size() == otherFile.size()) {
                equals = true;
                Iterator i = this.lineIterator();
                Iterator j = otherFile.lineIterator();
                while (i.hasNext()) {
                    PropertyLine otherLine;
                    PropertyLine myLine = (PropertyLine)i.next();
                    if (myLine.equals(otherLine = (PropertyLine)j.next())) continue;
                    equals = false;
                    break;
                }
            }
        }
        return equals;
    }

    public String toString() {
        String toString = "?";
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.serialize(stream, (IProgressMonitor)new NullProgressMonitor());
            toString = new String(stream.toByteArray());
        }
        catch (IOException iOException) {}
        return toString;
    }

    public boolean isRemovingMidlets() {
        return this.removingMidlets;
    }

    public void setRemovingMidlets(boolean b) {
        this.removingMidlets = b;
    }

    private class PropertyFileIterator
    implements Iterator {
        private int typeOfInterest;
        private Iterator contentsIterator;

        PropertyFileIterator(int typeOfInterest) {
            this.typeOfInterest = typeOfInterest;
            this.contentsIterator = PropertyFile.this.lineIterator();
        }

        public boolean hasNext() {
            return this.contentsIterator.hasNext();
        }

        public Object next() {
            String next = null;
            PropertyLine line = (PropertyLine)this.contentsIterator.next();
            switch (this.typeOfInterest) {
                case 0: {
                    next = line.getKey();
                    break;
                }
                case 1: {
                    next = line.getValue();
                    break;
                }
                case 2: {
                    next = line.getLeadingComment();
                }
            }
            return next;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

