/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mtj.core.IEclipseMtjCoreConstants;
import org.eclipse.mtj.core.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class MtjCorePlugin
extends AbstractUIPlugin
implements IEclipseMtjCoreConstants {
    private static MtjCorePlugin plugin;
    private static final IStatus PROMPTER_STATUS;

    static {
        PROMPTER_STATUS = new Status(1, "org.eclipse.debug.ui", 200, "", null);
    }

    public MtjCorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static MtjCorePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"Mtj_Core", (String)path);
    }

    public static String getId() {
        return "org.eclipse.mtj.core";
    }

    public static void throwCoreException(int severity, int code, Throwable exception) throws CoreException {
        String message = null;
        if (exception != null) {
            message = exception.getMessage();
        }
        if (message == null) {
            message = Messages.MtjCorePlugin_NoMessage;
        }
        Status status = new Status(severity, "org.eclipse.mtj.core.ui", code, message, exception);
        throw new CoreException((IStatus)status);
    }

    public static void log(int severity, String message) {
        MtjCorePlugin.log(severity, message, null);
    }

    public static void log(int severity, Throwable throwable) {
        MtjCorePlugin.log(severity, throwable.getMessage(), throwable);
    }

    public static void log(int severity, String message, Throwable throwable) {
        MtjCorePlugin plugin = MtjCorePlugin.getDefault();
        String id = "org.eclipse.mtj.core.ui";
        Status status = new Status(severity, id, 0, message, throwable);
        plugin.getLog().log((IStatus)status);
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void throwCoreException(int severity, int code, String message) throws CoreException {
        if (message == null) {
            message = Messages.MtjCorePlugin_NoMessage;
        }
        Status status = new Status(severity, "org.eclipse.mtj.core.ui", code, message, null);
        throw new CoreException((IStatus)status);
    }

    public static Object statusPrompt(IStatus status, Object source) throws CoreException {
        Object result = null;
        IStatusHandler prompterStatus = DebugPlugin.getDefault().getStatusHandler(PROMPTER_STATUS);
        if (prompterStatus == null) {
            throw new CoreException(status);
        }
        result = prompterStatus.handleStatus(status, source);
        return result;
    }

    public static Shell getActiveShell() {
        if (plugin == null) {
            return null;
        }
        IWorkbench workBench = plugin.getWorkbench();
        if (workBench == null) {
            return null;
        }
        IWorkbenchWindow workBenchWindow = workBench.getActiveWorkbenchWindow();
        if (workBenchWindow == null) {
            return null;
        }
        return workBenchWindow.getShell();
    }

    public static IStatus newStatus(int severity, int code, String message) {
        return MtjCorePlugin.newStatus(severity, code, message, null);
    }

    public static IStatus newStatus(int severity, int code, String message, Throwable exception) {
        return new Status(severity, "org.eclipse.mtj.core.ui", code, message, exception);
    }

    public static void setResourcesAsDerived(IContainer container) throws CoreException {
        if (container.exists()) {
            container.setDerived(true);
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IContainer) {
                    MtjCorePlugin.setResourcesAsDerived((IContainer)resource);
                } else {
                    resource.setDerived(true);
                }
                ++i;
            }
        }
    }

    public static Object getConfigurationSpecification(String identifier) throws CoreException {
        return null;
    }
}

