/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.core.Messages;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.exception.MtjException;
import org.osgi.framework.Bundle;

public class MtjServices {
    private static MtjServices instance;
    Properties properties = null;

    public static MtjServices getInstance() {
        if (instance == null) {
            instance = new MtjServices();
        }
        return instance;
    }

    public MtjExtension[] getImplementations(ExtensionType extensionType, String version, String vendor) {
        return this.getImplementations(extensionType, version, vendor, true);
    }

    public MtjExtension[] getImplementations(ExtensionType extensionType, String version, String vendor, String project) {
        return this.getImplementations(extensionType, version, vendor, project, true);
    }

    public MtjExtension[] getImplementations(ExtensionType extensionType, String version, String vendor, boolean onlyActive) {
        return this.getImplementations(extensionType, version, vendor, null, onlyActive);
    }

    public MtjExtension[] getImplementations(ExtensionType extensionType, String version, String vendor, String project, boolean onlyActive) {
        ArrayList l = this.loadExtensions(MtjCorePlugin.getId(), extensionType);
        ArrayList<MtjExtension> r = new ArrayList<MtjExtension>();
        int i = 0;
        while (i < l.size()) {
            MtjExtension ex = (MtjExtension)l.get(i);
            boolean active = this.isActive(ex.getId(), extensionType, project);
            if (extensionType.toString().equalsIgnoreCase("PERSISTENT_STORE_PROVIDER")) {
                ex.setActive(true);
                active = true;
            } else {
                ex.setActive(active);
            }
            if (!(onlyActive && !active || vendor != null && !vendor.equals(ex.getVendor()) || version != null && !version.equals(ex.getVersion()))) {
                r.add(ex);
            }
            ++i;
        }
        MtjExtension[] ret = new MtjExtension[r.size()];
        int i2 = 0;
        while (i2 < r.size()) {
            ret[i2] = (MtjExtension)r.get(i2);
            ++i2;
        }
        return ret;
    }

    public MtjExtension[] getAllImplementations() {
        return this.getAllImplementations(null);
    }

    public MtjExtension[] getAllImplementations(String project) {
        ArrayList l = this.loadExtensions(MtjCorePlugin.getId(), null);
        MtjExtension[] ret = new MtjExtension[l.size()];
        int i = 0;
        while (i < l.size()) {
            ret[i] = (MtjExtension)l.get(i);
            ret[i].setActive(this.isActive(ret[i].getId(), ret[i].getType(), project));
            ++i;
        }
        return ret;
    }

    public boolean isActive(String id, ExtensionType type) {
        return this.isActive(id, type, null);
    }

    public boolean isActive(String id, ExtensionType type, String project) {
        Properties props = this.getProperties();
        if (props == null) {
            return true;
        }
        String val = (String)props.get(this.getPropertyName(id, type, project));
        if (val == null) {
            if (project != null) {
                return this.isActive(id, type, null);
            }
            return true;
        }
        return new Boolean(val);
    }

    public void setActive(String id, ExtensionType type, boolean isActive) throws MtjException {
        this.setActive(id, type, null, isActive);
    }

    public void setActive(String id, ExtensionType type, String project, boolean isActive) throws MtjException {
        Properties props = this.getProperties();
        if (props == null) {
            throw new MtjException(Messages.MtjServices_ErrorGettingMtjProperties);
        }
        props.setProperty(this.getPropertyName(id, type, project), "" + isActive);
        this.storeProperties();
    }

    private String getPropertyName(String id, ExtensionType type, String project) {
        return "plugin." + type.getName() + "_" + id + "." + (project != null ? project : "all") + ".active";
    }

    public ArrayList loadExtensions(String plugin_id, ExtensionType extensionType) {
        IExtensionRegistry r = Platform.getExtensionRegistry();
        IExtensionPoint[] ps = r.getExtensionPoints(plugin_id);
        ArrayList<Object> l = new ArrayList<Object>();
        int j = 0;
        while (j < ps.length) {
            IConfigurationElement[] c;
            IExtensionPoint p = ps[j];
            if (p.getSimpleIdentifier() != null && (extensionType == null || p.getSimpleIdentifier().equalsIgnoreCase(this.capitalizeIdentifier(extensionType.toString()))) && (c = p.getConfigurationElements()) != null) {
                int i = 0;
                while (i < c.length) {
                    try {
                        Object o = c[i].createExecutableExtension("class");
                        if (o != null && o instanceof MtjExtension) {
                            l.add(o);
                        }
                    }
                    catch (CoreException coreException) {}
                    ++i;
                }
            }
            ++j;
        }
        return l;
    }

    public String capitalizeIdentifier(String _value) {
        if (_value == null) {
            return null;
        }
        StringTokenizer _utokenizer = new StringTokenizer(_value, "_", true);
        StringBuffer _uresult = new StringBuffer();
        while (_utokenizer.hasMoreTokens()) {
            String _word;
            String _tmp = _word = _utokenizer.nextToken();
            if ((_word = _word.toLowerCase()).equals(_tmp.toUpperCase()) || !_utokenizer.hasMoreTokens()) {
                if (_word.equals("_")) continue;
                _uresult.append(_word);
                continue;
            }
            _uresult.append(String.valueOf(_word) + " ");
        }
        return this.capitalize(_uresult.toString());
    }

    private String capitalize(String _value) {
        if (_value == null) {
            return null;
        }
        StringTokenizer _tokenizer = new StringTokenizer(_value, " ");
        StringBuffer _result = new StringBuffer();
        while (_tokenizer.hasMoreTokens()) {
            StringBuffer _word = new StringBuffer(_tokenizer.nextToken());
            _word.replace(0, 1, _word.substring(0, 1).toUpperCase());
            if (!_tokenizer.hasMoreTokens()) {
                _result.append(_word);
                continue;
            }
            _result.append(_word + " ");
        }
        String _tmp = _result.toString();
        _tmp = String.valueOf(_tmp.substring(0, 1).toLowerCase()) + _tmp.substring(1);
        return this.replacePattern(_tmp, " ", "");
    }

    private String replacePattern(String _original, String _pattern, String _replacement) {
        StringTokenizer _strtok = new StringTokenizer(_original, _pattern, true);
        StringBuffer _result = new StringBuffer();
        if (_replacement == null) {
            _replacement = "";
        }
        while (_strtok.hasMoreTokens()) {
            String _token = _strtok.nextToken();
            if (_token.equals(_pattern)) {
                _result.append(_replacement);
                continue;
            }
            _result.append(_token);
        }
        return _result.toString();
    }

    public AdminGuiProvider getCorrespondingAdminGuiProvider(MtjExtension extension) throws MtjException {
        MtjExtension[] exts = MtjServices.getInstance().getImplementations(ExtensionType.ADMIN_GUI_PROVIDER_LITERAL, null, null, false);
        int i = 0;
        while (i < exts.length) {
            AdminGuiProvider a = (AdminGuiProvider)exts[i];
            if (a.getOwner() == extension) {
                return a;
            }
            ++i;
        }
        return null;
    }

    public ProjectExtensionProvider getProjectExtension(ProjectType projectType) {
        for (ProjectExtensionProvider p : this.loadExtensions("projectExtension")) {
            if (!p.getProjectType().toString().equals(projectType.getName())) continue;
            return p;
        }
        return null;
    }

    public ArrayList loadExtensions(String extensionName) {
        IExtensionRegistry r = Platform.getExtensionRegistry();
        IExtensionPoint[] ps = r.getExtensionPoints(MtjCorePlugin.getId());
        ArrayList<Object> l = new ArrayList<Object>();
        int j = 0;
        while (j < ps.length) {
            IConfigurationElement[] c;
            IExtensionPoint p = ps[j];
            if (p.getSimpleIdentifier() != null && p.getSimpleIdentifier().equalsIgnoreCase(extensionName) && (c = p.getConfigurationElements()) != null) {
                int i = 0;
                while (i < c.length) {
                    try {
                        Object o = c[i].createExecutableExtension("class");
                        if (o != null) {
                            l.add(o);
                        }
                    }
                    catch (CoreException x) {
                        x.printStackTrace();
                    }
                    ++i;
                }
            }
            ++j;
        }
        return l;
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            try {
                this.properties.load(new FileInputStream(this.getFileName()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                return this.properties;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return this.properties;
    }

    private void storeProperties() throws MtjException {
        if (this.properties != null) {
            try {
                this.properties.store(new FileOutputStream(this.getFileName()), "");
            }
            catch (FileNotFoundException e) {
                try {
                    File file = new File(this.getFileName());
                    file.mkdirs();
                    file.createNewFile();
                    this.properties.store(new FileOutputStream(this.getFileName()), "");
                }
                catch (Exception exception) {
                    throw new MtjException(Messages.MtjServices_ErrorStoringMtjProperties, e);
                }
            }
            catch (IOException e) {
                throw new MtjException(Messages.MtjServices_ErrorStoringMtjProperties, e);
            }
        }
    }

    private String getFileName() throws IOException {
        StringBuffer sb = new StringBuffer();
        Path path = new Path("");
        String url = FileLocator.toFileURL((URL)FileLocator.find((Bundle)MtjCorePlugin.getDefault().getBundle(), (IPath)path, null)).toString();
        if (url.startsWith("file:/")) {
            url = url.substring("file:/".length());
        }
        sb.append(url);
        sb.append("mtj.properties");
        return sb.toString();
    }
}

