/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.internal.ota;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.internal.utils.Utils;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.handler.AbstractHttpHandler;

public class OTAHandler
extends AbstractHttpHandler {
    private static final long serialVersionUID = 1L;
    private static final String[] KNOWN_MIME_TYPES = new String[]{"jad", "text/vnd.sun.j2me.app-descriptor", "jar", "application/java-archive"};
    private static Map mimeTypeMap;

    private static Map getMimeTypeMap() {
        if (mimeTypeMap == null) {
            mimeTypeMap = new HashMap();
            int i = 0;
            while (i < KNOWN_MIME_TYPES.length) {
                mimeTypeMap.put(KNOWN_MIME_TYPES[i++], KNOWN_MIME_TYPES[i++]);
            }
        }
        return mimeTypeMap;
    }

    public String getName() {
        return "EclipseME Over the Air Handler";
    }

    public void handle(String pathInContext, String pathParams, HttpRequest request, HttpResponse response) throws HttpException, IOException {
        String project = null;
        String file = null;
        StringTokenizer st = new StringTokenizer(pathInContext, "/");
        if (st.hasMoreTokens()) {
            project = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            file = st.nextToken();
        }
        if (project != null && file != null) {
            try {
                this.handle(project, file, pathParams, request, response);
            }
            catch (CoreException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    private String getContentEncoding(IFile requestedFile) {
        return requestedFile.getFileExtension().equals("jad") ? "UTF-8" : null;
    }

    private String getContentType(IFile requestedFile) {
        String contentType = (String)OTAHandler.getMimeTypeMap().get(requestedFile.getFileExtension());
        return contentType != null ? contentType : "application/octet-stream";
    }

    private IJavaProject getJavaProject(String projectName) {
        IJavaProject javaProject = null;
        IWorkspaceRoot root = MtjCorePlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        if (project != null) {
            javaProject = JavaCore.create((IProject)project);
        }
        return javaProject;
    }

    private void handle(String project, String file, String pathParams, HttpRequest request, HttpResponse response) throws CoreException, IOException {
        IJavaProject javaProject = this.getJavaProject(project);
        if (javaProject != null) {
            this.handle(javaProject, file, pathParams, request, response);
        }
    }

    private void handle(IJavaProject javaProject, String file, String pathParams, HttpRequest request, HttpResponse response) throws CoreException, IOException {
        IFile requestedFile;
        String deploymentFolderName = "";
        IFolder deployedFolder = javaProject.getProject().getFolder(deploymentFolderName);
        if (deployedFolder.exists() && (requestedFile = deployedFolder.getFile(file)).exists()) {
            this.sendFile(requestedFile, response);
        }
    }

    private void sendFile(IFile requestedFile, HttpResponse response) throws CoreException, IOException {
        String contentType = this.getContentType(requestedFile);
        String contentEncoding = this.getContentEncoding(requestedFile);
        File javaFile = new File(requestedFile.getLocation().toOSString());
        response.setCharacterEncoding(contentEncoding);
        response.setContentType(contentType);
        response.setContentLength((int)javaFile.length());
        InputStream is = requestedFile.getContents();
        OutputStream os = response.getOutputStream();
        Utils.copyInputToOutput(is, os);
        os.close();
        is.close();
        response.commit();
    }
}

