/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.version;

import java.util.StringTokenizer;

public class Version
implements Comparable {
    private String major;
    private String minor;
    private String secondary;
    private String patch;
    private String versionString;

    public Version(String versionString) {
        this.versionString = versionString;
        this.major = "";
        this.minor = "";
        this.secondary = "";
        this.patch = "";
        this.parseVersionString(versionString);
    }

    public int compareTo(Object o) {
        return this.compareTo((Version)o);
    }

    public int compareTo(Version version) {
        int value = this.major.compareTo(version.major);
        if (value != 0) {
            return value;
        }
        value = this.minor.compareTo(version.minor);
        if (value != 0) {
            return value;
        }
        value = this.secondary.compareTo(version.secondary);
        if (value != 0) {
            return value;
        }
        value = this.patch.compareTo(version.patch);
        return value;
    }

    public boolean equals(Object object) {
        return object instanceof Version && this.equals((Version)object);
    }

    public boolean equals(Version version) {
        return this.compareTo(version) == 0;
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getPatch() {
        return this.patch;
    }

    public String getSecondary() {
        return this.secondary;
    }

    public String toString() {
        return this.versionString;
    }

    private void parseVersionString(String vString) {
        StringTokenizer st;
        int index = vString.indexOf(95);
        if (index != -1) {
            this.patch = vString.substring(index + 1);
            vString = vString.substring(0, index);
        }
        if ((st = new StringTokenizer(vString, ".")).hasMoreTokens()) {
            this.major = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.minor = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            this.secondary = st.nextToken();
        }
    }
}

