/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.RunnableAction;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class RunnableActionExecutor
implements IRunnableWithProgress {
    private String fActionName;
    private List fActionElements = new ArrayList();
    private Shell fTaskShell = MtjCoreUiPlugin.getActiveWorkbenchShell();

    public RunnableActionExecutor(String taskName) {
        this.fActionName = taskName;
    }

    public boolean runWithDialog(Shell shell) {
        ProgressMonitorDialog d = new ProgressMonitorDialog(shell);
        d.create();
        this.fTaskShell = d.getShell();
        try {
            d.run(true, true, (IRunnableWithProgress)this);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = Messages.RunnableActionExecutor_Project_Error;
            MessageBox message = new MessageBox(shell, 1);
            message.setMessage(String.valueOf(title) + e.getMessage());
            e.printStackTrace();
            message.open();
            return false;
        }
        return true;
    }

    public void insertInitialAction(RunnableAction act) {
        ArrayList<RunnableAction> newActions = new ArrayList<RunnableAction>();
        newActions.add(act);
        Iterator tIter = this.fActionElements.iterator();
        while (tIter.hasNext()) {
            newActions.add((RunnableAction)tIter.next());
        }
        this.fActionElements = newActions;
    }

    public void addAction(RunnableAction act) {
        this.fActionElements.add(act);
    }

    public void addActions(RunnableAction[] acts) {
        int i = 0;
        while (i < acts.length) {
            this.fActionElements.add(acts[i]);
            ++i;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(this.fActionName, this.calculateTotalWorkunits());
        for (RunnableAction task : this.fActionElements) {
            if (task.getName() != null) {
                monitor.subTask(task.getName());
            }
            task.getRunnable(this.fTaskShell).run(monitor);
            monitor.worked(task.getUnits());
        }
    }

    public int calculateTotalWorkunits() {
        Iterator taskIter = this.fActionElements.iterator();
        int result = 0;
        while (taskIter.hasNext()) {
            result += ((RunnableAction)taskIter.next()).getUnits();
        }
        return result;
    }
}

