/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplp.nokia.pcsuite.impl;

import java.io.IOException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.api.devices.impl.DevicesFactoryImpl;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.CdcDeployment;
import org.eclipse.mtj.api.model.MidletDeployment;
import org.eclipse.mtj.api.model.ResourceDeployment;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.PCSuiteMessages;
import org.eclipse.mtj.extension.dplp.nokia.pcsuite.PcsuitePlugin;

public class DeploymentProviderImpl extends MtjExtensionImpl implements DeploymentProvider {

	private Deployer deployer = null;
	
	public DeploymentProviderImpl() {
		super();
		
		setId(PcsuitePlugin.getDefault().getBundle().getSymbolicName());
		setDescription(PCSuiteMessages.DeploymentProviderImpl_0);
		setVendor(PCSuiteMessages.DeploymentProviderImpl_1);
		setVersion(PCSuiteMessages.DeploymentProviderImpl_2);
		setType(ExtensionType.DEPLOYMENT_PROVIDER_LITERAL);
		deployer = new Deployer();
	}

	public String getName() {
		return PCSuiteMessages.DeploymentProviderImpl_3;
	}

	public Device[] getDevices() throws MtjException {
		String[] terminals = deployer.getTerminals();
		if(terminals == null) return null;
		Device[] devices = new Device[terminals.length];
		DevicesFactory factory = new DevicesFactoryImpl();
		for(int i=0; i<devices.length;i++){
			Device device = factory.createDevice();
			device.setName(terminals[i]);
			device.setVendor(PCSuiteMessages.DeploymentProviderImpl_4);
			device.setDescription(PCSuiteMessages.DeploymentProviderImpl_5);
			device.setCommunicationProtocol(DeviceCommunicationProtocol.get(DeviceCommunicationProtocol.PROTOCOL_OBEX));
			devices[i] = device;
		}		
		return devices;
	}

	public PlatformType getPlatformType() throws MtjException {
		return PlatformType.get(PlatformType.REAL_DEVICE);
	}

	public DeviceCommunicationProtocol[] getSupportedProtocols() throws MtjException {
		DeviceCommunicationProtocol[] dcpList = new DeviceCommunicationProtocol[1];
		dcpList[0] = DeviceCommunicationProtocol.get(DeviceCommunicationProtocol.PROTOCOL_OBEX);
		return dcpList;
	}

	public void deploy(Deployment deployment, Device[] devices, DeviceCommunicationProtocol transferProtocol, IProgressMonitor monitor) throws MtjException {
		//monitor.beginTask("deploying", devices.length);
		for(int i=0; i<devices.length; i++){
			if(deployment instanceof MidletDeployment){
				try {
					deployer.deploy(((MidletDeployment)deployment).getJad(), ((MidletDeployment)deployment).getJar(), devices[i].getName());
					//monitor.worked(i+1);
					
				} catch (UnsatisfiedLinkError e) {
					e.printStackTrace();
					throw new MtjException(e.getMessage());
				} catch (IOException e) {
					throw new MtjException(PCSuiteMessages.DeploymentProviderImpl_6 + e.getMessage());
				}
			}else if(deployment instanceof ResourceDeployment){
				// TODO to be implemented
				return;
			}else if(deployment instanceof CdcDeployment){
				// TODO to be implemented					
				return;
			}
		}
		//monitor.done();
	}

	public DeviceStatus getStatus(Device device) throws MtjException {
		// always return DEVICE_STATUS_OK, since only connected devices are stored
		return DeviceStatus.get(DeviceStatus.DEVICE_STATUS_OK);
	}


}
