/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.extension.dpp.ui.impl;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dpp.impl.DevicePlatformProviderImpl;
import org.eclipse.mtj.extension.dpp.ui.DevicePlatformProviderUiPlugin;
import org.eclipse.mtj.extension.dpp.ui.Messages;
import org.eclipse.swt.widgets.Composite;

public class AdminGuiProviderImpl extends MtjExtensionImpl implements
		AdminGuiProvider {

	public AdminGuiProviderImpl() {
		super();

		setId(DevicePlatformProviderUiPlugin.getDefault().getBundle().getSymbolicName());
		setDescription(Messages.AdminGuiProviderImpl_PluginDescription);
		setVendor(Messages.AdminGuiProviderImpl_PluginVendor);
		setVersion(Messages.AdminGuiProviderImpl_PluginVersion);
		setType(ExtensionType.ADMIN_GUI_PROVIDER_LITERAL);
	}

	public Composite create(Composite composite, int style) throws MtjException {
		AdminPage page = new AdminPage(composite, style);
		
		return page;
	}

	/**
	 * Method returns reference to the master extension, like Device Platform
	 * Provider.
	 * 
	 * @return
	 */
	public MtjExtension getOwner() throws MtjException {
		return DevicePlatformProviderImpl.getDefault();
	}

    /**
     * With the method the extension point implementor can create it's PreferencePage.
     * 
     * @return
     */
    public PreferencePage getPreferencePage() {
    	return null;
    }

}
