/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.devices.Configuration;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.devices.DevicesPackage;

import org.eclipse.mtj.api.enumerations.PlatformType;

import org.eclipse.mtj.api.extension.MtjExtension;

import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Device Platform</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getDevices <em>Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getConfiguration <em>Configuration</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getVendor <em>Vendor</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isDebugEnabled <em>Debug Enabled</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isPredeploymentRequired <em>Predeployment Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isExecutableTargetRequired <em>Executable Target Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isKeepAlivePortRequired <em>Keep Alive Port Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isPreferencesDialogAvailable <em>Preferences Dialog Available</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#isUtilitesDialogAvailable <em>Utilites Dialog Available</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DevicePlatformImpl#getDevicePlatformProvider <em>Device Platform Provider</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DevicePlatformImpl extends EObjectImpl implements DevicePlatform {
	/**
	 * The cached value of the '{@link #getDevices() <em>Devices</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDevices()
	 * @generated
	 * @ordered
	 */
	protected EList devices = null;

	/**
	 * The default value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected static final PlatformType TYPE_EDEFAULT = PlatformType.EXECUTABLE_EMULATOR_LITERAL;

	/**
	 * The cached value of the '{@link #getType() <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getType()
	 * @generated
	 * @ordered
	 */
	protected PlatformType type = TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getConfiguration() <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfiguration()
	 * @generated
	 * @ordered
	 */
	protected Configuration configuration = null;

	/**
	 * The cached value of the '{@link #getRuntimePlatformDefinitions() <em>Runtime Platform Definitions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimePlatformDefinitions()
	 * @generated
	 * @ordered
	 */
	protected EList runtimePlatformDefinitions = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected static final String VENDOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected String vendor = VENDOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #isDebugEnabled() <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDebugEnabled()
	 * @generated
	 * @ordered
	 */
	protected static final boolean DEBUG_ENABLED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isDebugEnabled() <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isDebugEnabled()
	 * @generated
	 * @ordered
	 */
	protected boolean debugEnabled = DEBUG_ENABLED_EDEFAULT;

	/**
	 * The default value of the '{@link #isPredeploymentRequired() <em>Predeployment Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPredeploymentRequired()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PREDEPLOYMENT_REQUIRED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPredeploymentRequired() <em>Predeployment Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPredeploymentRequired()
	 * @generated
	 * @ordered
	 */
	protected boolean predeploymentRequired = PREDEPLOYMENT_REQUIRED_EDEFAULT;

	/**
	 * The default value of the '{@link #isExecutableTargetRequired() <em>Executable Target Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExecutableTargetRequired()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXECUTABLE_TARGET_REQUIRED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isExecutableTargetRequired() <em>Executable Target Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExecutableTargetRequired()
	 * @generated
	 * @ordered
	 */
	protected boolean executableTargetRequired = EXECUTABLE_TARGET_REQUIRED_EDEFAULT;

	/**
	 * The default value of the '{@link #isKeepAlivePortRequired() <em>Keep Alive Port Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKeepAlivePortRequired()
	 * @generated
	 * @ordered
	 */
	protected static final boolean KEEP_ALIVE_PORT_REQUIRED_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isKeepAlivePortRequired() <em>Keep Alive Port Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isKeepAlivePortRequired()
	 * @generated
	 * @ordered
	 */
	protected boolean keepAlivePortRequired = KEEP_ALIVE_PORT_REQUIRED_EDEFAULT;

	/**
	 * The default value of the '{@link #isPreferencesDialogAvailable() <em>Preferences Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPreferencesDialogAvailable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PREFERENCES_DIALOG_AVAILABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPreferencesDialogAvailable() <em>Preferences Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPreferencesDialogAvailable()
	 * @generated
	 * @ordered
	 */
	protected boolean preferencesDialogAvailable = PREFERENCES_DIALOG_AVAILABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isUtilitesDialogAvailable() <em>Utilites Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUtilitesDialogAvailable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean UTILITES_DIALOG_AVAILABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isUtilitesDialogAvailable() <em>Utilites Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isUtilitesDialogAvailable()
	 * @generated
	 * @ordered
	 */
	protected boolean utilitesDialogAvailable = UTILITES_DIALOG_AVAILABLE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDevicePlatformProvider() <em>Device Platform Provider</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDevicePlatformProvider()
	 * @generated
	 * @ordered
	 */
	protected MtjExtension devicePlatformProvider = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DevicePlatformImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DevicesPackage.eINSTANCE.getDevicePlatform();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDevices() {
		if (devices == null) {
			devices = new EObjectContainmentEList(Device.class, this, DevicesPackage.DEVICE_PLATFORM__DEVICES);
		}
		return devices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public PlatformType getType() {
		return type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setType(PlatformType newType) {
		PlatformType oldType = type;
		type = newType == null ? TYPE_EDEFAULT : newType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__TYPE, oldType, type));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Configuration getConfiguration() {
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConfiguration(Configuration newConfiguration, NotificationChain msgs) {
		Configuration oldConfiguration = configuration;
		configuration = newConfiguration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__CONFIGURATION, oldConfiguration, newConfiguration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfiguration(Configuration newConfiguration) {
		if (newConfiguration != configuration) {
			NotificationChain msgs = null;
			if (configuration != null)
				msgs = ((InternalEObject)configuration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE_PLATFORM__CONFIGURATION, null, msgs);
			if (newConfiguration != null)
				msgs = ((InternalEObject)newConfiguration).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE_PLATFORM__CONFIGURATION, null, msgs);
			msgs = basicSetConfiguration(newConfiguration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__CONFIGURATION, newConfiguration, newConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRuntimePlatformDefinitions() {
		if (runtimePlatformDefinitions == null) {
			runtimePlatformDefinitions = new EObjectContainmentEList(RuntimePlatformDefinition.class, this, DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS);
		}
		return runtimePlatformDefinitions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVendor() {
		return vendor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVendor(String newVendor) {
		String oldVendor = vendor;
		vendor = newVendor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__VENDOR, oldVendor, vendor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isDebugEnabled() {
		return debugEnabled;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDebugEnabled(boolean newDebugEnabled) {
		boolean oldDebugEnabled = debugEnabled;
		debugEnabled = newDebugEnabled;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__DEBUG_ENABLED, oldDebugEnabled, debugEnabled));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPredeploymentRequired() {
		return predeploymentRequired;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPredeploymentRequired(boolean newPredeploymentRequired) {
		boolean oldPredeploymentRequired = predeploymentRequired;
		predeploymentRequired = newPredeploymentRequired;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED, oldPredeploymentRequired, predeploymentRequired));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isExecutableTargetRequired() {
		return executableTargetRequired;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExecutableTargetRequired(boolean newExecutableTargetRequired) {
		boolean oldExecutableTargetRequired = executableTargetRequired;
		executableTargetRequired = newExecutableTargetRequired;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED, oldExecutableTargetRequired, executableTargetRequired));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isKeepAlivePortRequired() {
		return keepAlivePortRequired;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKeepAlivePortRequired(boolean newKeepAlivePortRequired) {
		boolean oldKeepAlivePortRequired = keepAlivePortRequired;
		keepAlivePortRequired = newKeepAlivePortRequired;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED, oldKeepAlivePortRequired, keepAlivePortRequired));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPreferencesDialogAvailable() {
		return preferencesDialogAvailable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPreferencesDialogAvailable(boolean newPreferencesDialogAvailable) {
		boolean oldPreferencesDialogAvailable = preferencesDialogAvailable;
		preferencesDialogAvailable = newPreferencesDialogAvailable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE, oldPreferencesDialogAvailable, preferencesDialogAvailable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isUtilitesDialogAvailable() {
		return utilitesDialogAvailable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUtilitesDialogAvailable(boolean newUtilitesDialogAvailable) {
		boolean oldUtilitesDialogAvailable = utilitesDialogAvailable;
		utilitesDialogAvailable = newUtilitesDialogAvailable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE, oldUtilitesDialogAvailable, utilitesDialogAvailable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MtjExtension getDevicePlatformProvider() {
		if (devicePlatformProvider != null && devicePlatformProvider.eIsProxy()) {
			MtjExtension oldDevicePlatformProvider = devicePlatformProvider;
			devicePlatformProvider = (MtjExtension)eResolveProxy((InternalEObject)devicePlatformProvider);
			if (devicePlatformProvider != oldDevicePlatformProvider) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER, oldDevicePlatformProvider, devicePlatformProvider));
			}
		}
		return devicePlatformProvider;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public MtjExtension basicGetDevicePlatformProvider() {
		return devicePlatformProvider;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDevicePlatformProvider(MtjExtension newDevicePlatformProvider) {
		MtjExtension oldDevicePlatformProvider = devicePlatformProvider;
		devicePlatformProvider = newDevicePlatformProvider;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER, oldDevicePlatformProvider, devicePlatformProvider));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DevicesPackage.DEVICE_PLATFORM__DEVICES:
					return ((InternalEList)getDevices()).basicRemove(otherEnd, msgs);
				case DevicesPackage.DEVICE_PLATFORM__CONFIGURATION:
					return basicSetConfiguration(null, msgs);
				case DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS:
					return ((InternalEList)getRuntimePlatformDefinitions()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE_PLATFORM__DEVICES:
				return getDevices();
			case DevicesPackage.DEVICE_PLATFORM__TYPE:
				return getType();
			case DevicesPackage.DEVICE_PLATFORM__CONFIGURATION:
				return getConfiguration();
			case DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS:
				return getRuntimePlatformDefinitions();
			case DevicesPackage.DEVICE_PLATFORM__NAME:
				return getName();
			case DevicesPackage.DEVICE_PLATFORM__VENDOR:
				return getVendor();
			case DevicesPackage.DEVICE_PLATFORM__VERSION:
				return getVersion();
			case DevicesPackage.DEVICE_PLATFORM__DEBUG_ENABLED:
				return isDebugEnabled() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED:
				return isPredeploymentRequired() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED:
				return isExecutableTargetRequired() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED:
				return isKeepAlivePortRequired() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE:
				return isPreferencesDialogAvailable() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE:
				return isUtilitesDialogAvailable() ? Boolean.TRUE : Boolean.FALSE;
			case DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER:
				if (resolve) return getDevicePlatformProvider();
				return basicGetDevicePlatformProvider();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE_PLATFORM__DEVICES:
				getDevices().clear();
				getDevices().addAll((Collection)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__TYPE:
				setType((PlatformType)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__CONFIGURATION:
				setConfiguration((Configuration)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS:
				getRuntimePlatformDefinitions().clear();
				getRuntimePlatformDefinitions().addAll((Collection)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__NAME:
				setName((String)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__VENDOR:
				setVendor((String)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__VERSION:
				setVersion((String)newValue);
				return;
			case DevicesPackage.DEVICE_PLATFORM__DEBUG_ENABLED:
				setDebugEnabled(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED:
				setPredeploymentRequired(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED:
				setExecutableTargetRequired(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED:
				setKeepAlivePortRequired(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE:
				setPreferencesDialogAvailable(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE:
				setUtilitesDialogAvailable(((Boolean)newValue).booleanValue());
				return;
			case DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER:
				setDevicePlatformProvider((MtjExtension)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE_PLATFORM__DEVICES:
				getDevices().clear();
				return;
			case DevicesPackage.DEVICE_PLATFORM__TYPE:
				setType(TYPE_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__CONFIGURATION:
				setConfiguration((Configuration)null);
				return;
			case DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS:
				getRuntimePlatformDefinitions().clear();
				return;
			case DevicesPackage.DEVICE_PLATFORM__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__VENDOR:
				setVendor(VENDOR_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__DEBUG_ENABLED:
				setDebugEnabled(DEBUG_ENABLED_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED:
				setPredeploymentRequired(PREDEPLOYMENT_REQUIRED_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED:
				setExecutableTargetRequired(EXECUTABLE_TARGET_REQUIRED_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED:
				setKeepAlivePortRequired(KEEP_ALIVE_PORT_REQUIRED_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE:
				setPreferencesDialogAvailable(PREFERENCES_DIALOG_AVAILABLE_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE:
				setUtilitesDialogAvailable(UTILITES_DIALOG_AVAILABLE_EDEFAULT);
				return;
			case DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER:
				setDevicePlatformProvider((MtjExtension)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE_PLATFORM__DEVICES:
				return devices != null && !devices.isEmpty();
			case DevicesPackage.DEVICE_PLATFORM__TYPE:
				return type != TYPE_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__CONFIGURATION:
				return configuration != null;
			case DevicesPackage.DEVICE_PLATFORM__RUNTIME_PLATFORM_DEFINITIONS:
				return runtimePlatformDefinitions != null && !runtimePlatformDefinitions.isEmpty();
			case DevicesPackage.DEVICE_PLATFORM__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DevicesPackage.DEVICE_PLATFORM__VENDOR:
				return VENDOR_EDEFAULT == null ? vendor != null : !VENDOR_EDEFAULT.equals(vendor);
			case DevicesPackage.DEVICE_PLATFORM__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case DevicesPackage.DEVICE_PLATFORM__DEBUG_ENABLED:
				return debugEnabled != DEBUG_ENABLED_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__PREDEPLOYMENT_REQUIRED:
				return predeploymentRequired != PREDEPLOYMENT_REQUIRED_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__EXECUTABLE_TARGET_REQUIRED:
				return executableTargetRequired != EXECUTABLE_TARGET_REQUIRED_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__KEEP_ALIVE_PORT_REQUIRED:
				return keepAlivePortRequired != KEEP_ALIVE_PORT_REQUIRED_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__PREFERENCES_DIALOG_AVAILABLE:
				return preferencesDialogAvailable != PREFERENCES_DIALOG_AVAILABLE_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__UTILITES_DIALOG_AVAILABLE:
				return utilitesDialogAvailable != UTILITES_DIALOG_AVAILABLE_EDEFAULT;
			case DevicesPackage.DEVICE_PLATFORM__DEVICE_PLATFORM_PROVIDER:
				return devicePlatformProvider != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (type: ");
		result.append(type);
		result.append(", name: ");
		result.append(name);
		result.append(", vendor: ");
		result.append(vendor);
		result.append(", version: ");
		result.append(version);
		result.append(", debugEnabled: ");
		result.append(debugEnabled);
		result.append(", predeploymentRequired: ");
		result.append(predeploymentRequired);
		result.append(", executableTargetRequired: ");
		result.append(executableTargetRequired);
		result.append(", keepAlivePortRequired: ");
		result.append(keepAlivePortRequired);
		result.append(", preferencesDialogAvailable: ");
		result.append(preferencesDialogAvailable);
		result.append(", utilitesDialogAvailable: ");
		result.append(utilitesDialogAvailable);
		result.append(')');
		return result.toString();
	}

} //DevicePlatformImpl
