/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Deployment Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getDeploymentType()
 * @model
 * @generated
 */
public final class DeploymentType extends AbstractEnumerator {
	/**
	 * The '<em><b>DEPLOYMENT TYPE MIDLET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT TYPE MIDLET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_MIDLET_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_TYPE_MIDLET = 0;

	/**
	 * The '<em><b>DEPLOYMENT TYPE CDC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT TYPE CDC</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_CDC_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_TYPE_CDC = 1;

	/**
	 * The '<em><b>DEPLOYMENT TYPE OSGI MIDLET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT TYPE OSGI MIDLET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_TYPE_OSGI_MIDLET = 2;

	/**
	 * The '<em><b>DEPLOYMENT TYPE RESOURCE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT TYPE RESOURCE</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_RESOURCE_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_TYPE_RESOURCE = 3;

	/**
	 * The '<em><b>DEPLOYMENT TYPE MIDLET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_MIDLET
	 * @generated
	 * @ordered
	 */
	public static final DeploymentType DEPLOYMENT_TYPE_MIDLET_LITERAL = new DeploymentType(DEPLOYMENT_TYPE_MIDLET, "DEPLOYMENT_TYPE_MIDLET");

	/**
	 * The '<em><b>DEPLOYMENT TYPE CDC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_CDC
	 * @generated
	 * @ordered
	 */
	public static final DeploymentType DEPLOYMENT_TYPE_CDC_LITERAL = new DeploymentType(DEPLOYMENT_TYPE_CDC, "DEPLOYMENT_TYPE_CDC");

	/**
	 * The '<em><b>DEPLOYMENT TYPE OSGI MIDLET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_OSGI_MIDLET
	 * @generated
	 * @ordered
	 */
	public static final DeploymentType DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL = new DeploymentType(DEPLOYMENT_TYPE_OSGI_MIDLET, "DEPLOYMENT_TYPE_OSGI_MIDLET");

	/**
	 * The '<em><b>DEPLOYMENT TYPE RESOURCE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_TYPE_RESOURCE
	 * @generated
	 * @ordered
	 */
	public static final DeploymentType DEPLOYMENT_TYPE_RESOURCE_LITERAL = new DeploymentType(DEPLOYMENT_TYPE_RESOURCE, "DEPLOYMENT_TYPE_RESOURCE");

	/**
	 * An array of all the '<em><b>Deployment Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final DeploymentType[] VALUES_ARRAY =
		new DeploymentType[] {
			DEPLOYMENT_TYPE_MIDLET_LITERAL,
			DEPLOYMENT_TYPE_CDC_LITERAL,
			DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL,
			DEPLOYMENT_TYPE_RESOURCE_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Deployment Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Deployment Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeploymentType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DeploymentType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Deployment Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeploymentType get(int value) {
		switch (value) {
			case DEPLOYMENT_TYPE_MIDLET: return DEPLOYMENT_TYPE_MIDLET_LITERAL;
			case DEPLOYMENT_TYPE_CDC: return DEPLOYMENT_TYPE_CDC_LITERAL;
			case DEPLOYMENT_TYPE_OSGI_MIDLET: return DEPLOYMENT_TYPE_OSGI_MIDLET_LITERAL;
			case DEPLOYMENT_TYPE_RESOURCE: return DEPLOYMENT_TYPE_RESOURCE_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private DeploymentType(int value, String name) {
		super(value, name);
	}

} //DeploymentType
