/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Expression</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getExpression()
 * @model
 * @generated
 */
public final class Expression extends AbstractEnumerator {
	/**
	 * The '<em><b>EXPRESSION LT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION LT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_LT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_LT = 0;

	/**
	 * The '<em><b>EXPRESSION LET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION LET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_LET_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_LET = 1;

	/**
	 * The '<em><b>EXPRESSION EQ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION EQ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_EQ_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_EQ = 2;

	/**
	 * The '<em><b>EXPRESSION NEQ</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION NEQ</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_NEQ_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_NEQ = 3;

	/**
	 * The '<em><b>EXPRESSION GET</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION GET</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_GET_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_GET = 4;

	/**
	 * The '<em><b>EXPRESSION GT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>EXPRESSION GT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_GT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int EXPRESSION_GT = 5;

	/**
	 * The '<em><b>EXPRESSION LT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_LT
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_LT_LITERAL = new Expression(EXPRESSION_LT, "EXPRESSION_LT");

	/**
	 * The '<em><b>EXPRESSION LET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_LET
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_LET_LITERAL = new Expression(EXPRESSION_LET, "EXPRESSION_LET");

	/**
	 * The '<em><b>EXPRESSION EQ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_EQ
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_EQ_LITERAL = new Expression(EXPRESSION_EQ, "EXPRESSION_EQ");

	/**
	 * The '<em><b>EXPRESSION NEQ</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_NEQ
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_NEQ_LITERAL = new Expression(EXPRESSION_NEQ, "EXPRESSION_NEQ");

	/**
	 * The '<em><b>EXPRESSION GET</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_GET
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_GET_LITERAL = new Expression(EXPRESSION_GET, "EXPRESSION_GET");

	/**
	 * The '<em><b>EXPRESSION GT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #EXPRESSION_GT
	 * @generated
	 * @ordered
	 */
	public static final Expression EXPRESSION_GT_LITERAL = new Expression(EXPRESSION_GT, "EXPRESSION_GT");

	/**
	 * An array of all the '<em><b>Expression</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final Expression[] VALUES_ARRAY =
		new Expression[] {
			EXPRESSION_LT_LITERAL,
			EXPRESSION_LET_LITERAL,
			EXPRESSION_EQ_LITERAL,
			EXPRESSION_NEQ_LITERAL,
			EXPRESSION_GET_LITERAL,
			EXPRESSION_GT_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Expression</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Expression</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Expression get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Expression result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Expression</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Expression get(int value) {
		switch (value) {
			case EXPRESSION_LT: return EXPRESSION_LT_LITERAL;
			case EXPRESSION_LET: return EXPRESSION_LET_LITERAL;
			case EXPRESSION_EQ: return EXPRESSION_EQ_LITERAL;
			case EXPRESSION_NEQ: return EXPRESSION_NEQ_LITERAL;
			case EXPRESSION_GET: return EXPRESSION_GET_LITERAL;
			case EXPRESSION_GT: return EXPRESSION_GT_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private Expression(int value, String name) {
		super(value, name);
	}

} //Expression
