/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Extension Type</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getExtensionType()
 * @model
 * @generated
 */
public final class ExtensionType extends AbstractEnumerator {
	/**
	 * The '<em><b>ADMIN GUI PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>ADMIN GUI PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #ADMIN_GUI_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int ADMIN_GUI_PROVIDER = 0;

	/**
	 * The '<em><b>BUILD MANAGEMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BUILD MANAGEMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BUILD_MANAGEMENT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BUILD_MANAGEMENT = 1;

	/**
	 * The '<em><b>BUILD PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>BUILD PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #BUILD_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int BUILD_PROVIDER = 2;

	/**
	 * The '<em><b>DEPLOYMENT MANAGEMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT MANAGEMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_MANAGEMENT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_MANAGEMENT = 3;

	/**
	 * The '<em><b>DEVICE PLATFORM PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE PLATFORM PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_PLATFORM_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_PLATFORM_PROVIDER = 4;

	/**
	 * The '<em><b>GUI BUILDER MANAGEMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUI BUILDER MANAGEMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUI_BUILDER_MANAGEMENT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUI_BUILDER_MANAGEMENT = 5;

	/**
	 * The '<em><b>GUI BUILDER PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>GUI BUILDER PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #GUI_BUILDER_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int GUI_BUILDER_PROVIDER = 6;

	/**
	 * The '<em><b>PACKAGING PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PACKAGING PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PACKAGING_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PACKAGING_PROVIDER = 7;

	/**
	 * The '<em><b>PREPROCESSING PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PREPROCESSING PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PREPROCESSING_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PREPROCESSING_PROVIDER = 8;

	/**
	 * The '<em><b>OBFUSCATION PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>OBFUSCATION PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #OBFUSCATION_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int OBFUSCATION_PROVIDER = 9;

	/**
	 * The '<em><b>SCREEN ENGINE PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SCREEN ENGINE PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SCREEN_ENGINE_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SCREEN_ENGINE_PROVIDER = 10;

	/**
	 * The '<em><b>SECURITY MANAGEMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SECURITY MANAGEMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SECURITY_MANAGEMENT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SECURITY_MANAGEMENT = 11;

	/**
	 * The '<em><b>SIGNING PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>SIGNING PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #SIGNING_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int SIGNING_PROVIDER = 12;

	/**
	 * The '<em><b>DRM ENCODING PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DRM ENCODING PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DRM_ENCODING_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DRM_ENCODING_PROVIDER = 13;

	/**
	 * The '<em><b>DEVICE MANAGEMENT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE MANAGEMENT</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_MANAGEMENT_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_MANAGEMENT = 14;

	/**
	 * The '<em><b>DEVICE DESCRIPTION PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEVICE DESCRIPTION PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEVICE_DESCRIPTION_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEVICE_DESCRIPTION_PROVIDER = 15;

	/**
	 * The '<em><b>PERSISTENT STORE PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PERSISTENT STORE PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PERSISTENT_STORE_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PERSISTENT_STORE_PROVIDER = 16;

	/**
	 * The '<em><b>DEPLOYMENT PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>DEPLOYMENT PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int DEPLOYMENT_PROVIDER = 17;

	/**
	 * The '<em><b>PREVERIFICATION PROVIDER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PREVERIFICATION PROVIDER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PREVERIFICATION_PROVIDER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PREVERIFICATION_PROVIDER = 18;

	/**
	 * The '<em><b>ADMIN GUI PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ADMIN_GUI_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType ADMIN_GUI_PROVIDER_LITERAL = new ExtensionType(ADMIN_GUI_PROVIDER, "ADMIN_GUI_PROVIDER");

	/**
	 * The '<em><b>BUILD MANAGEMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUILD_MANAGEMENT
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType BUILD_MANAGEMENT_LITERAL = new ExtensionType(BUILD_MANAGEMENT, "BUILD_MANAGEMENT");

	/**
	 * The '<em><b>BUILD PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #BUILD_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType BUILD_PROVIDER_LITERAL = new ExtensionType(BUILD_PROVIDER, "BUILD_PROVIDER");

	/**
	 * The '<em><b>DEPLOYMENT MANAGEMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_MANAGEMENT
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DEPLOYMENT_MANAGEMENT_LITERAL = new ExtensionType(DEPLOYMENT_MANAGEMENT, "DEPLOYMENT_MANAGEMENT");

	/**
	 * The '<em><b>DEVICE PLATFORM PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_PLATFORM_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DEVICE_PLATFORM_PROVIDER_LITERAL = new ExtensionType(DEVICE_PLATFORM_PROVIDER, "DEVICE_PLATFORM_PROVIDER");

	/**
	 * The '<em><b>GUI BUILDER MANAGEMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUI_BUILDER_MANAGEMENT
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType GUI_BUILDER_MANAGEMENT_LITERAL = new ExtensionType(GUI_BUILDER_MANAGEMENT, "GUI_BUILDER_MANAGEMENT");

	/**
	 * The '<em><b>GUI BUILDER PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #GUI_BUILDER_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType GUI_BUILDER_PROVIDER_LITERAL = new ExtensionType(GUI_BUILDER_PROVIDER, "GUI_BUILDER_PROVIDER");

	/**
	 * The '<em><b>PACKAGING PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PACKAGING_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType PACKAGING_PROVIDER_LITERAL = new ExtensionType(PACKAGING_PROVIDER, "PACKAGING_PROVIDER");

	/**
	 * The '<em><b>PREPROCESSING PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PREPROCESSING_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType PREPROCESSING_PROVIDER_LITERAL = new ExtensionType(PREPROCESSING_PROVIDER, "PREPROCESSING_PROVIDER");

	/**
	 * The '<em><b>OBFUSCATION PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #OBFUSCATION_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType OBFUSCATION_PROVIDER_LITERAL = new ExtensionType(OBFUSCATION_PROVIDER, "OBFUSCATION_PROVIDER");

	/**
	 * The '<em><b>SCREEN ENGINE PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SCREEN_ENGINE_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType SCREEN_ENGINE_PROVIDER_LITERAL = new ExtensionType(SCREEN_ENGINE_PROVIDER, "SCREEN_ENGINE_PROVIDER");

	/**
	 * The '<em><b>SECURITY MANAGEMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SECURITY_MANAGEMENT
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType SECURITY_MANAGEMENT_LITERAL = new ExtensionType(SECURITY_MANAGEMENT, "SECURITY_MANAGEMENT");

	/**
	 * The '<em><b>SIGNING PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #SIGNING_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType SIGNING_PROVIDER_LITERAL = new ExtensionType(SIGNING_PROVIDER, "SIGNING_PROVIDER");

	/**
	 * The '<em><b>DRM ENCODING PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DRM_ENCODING_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DRM_ENCODING_PROVIDER_LITERAL = new ExtensionType(DRM_ENCODING_PROVIDER, "DRM_ENCODING_PROVIDER");

	/**
	 * The '<em><b>DEVICE MANAGEMENT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_MANAGEMENT
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DEVICE_MANAGEMENT_LITERAL = new ExtensionType(DEVICE_MANAGEMENT, "DEVICE_MANAGEMENT");

	/**
	 * The '<em><b>DEVICE DESCRIPTION PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEVICE_DESCRIPTION_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DEVICE_DESCRIPTION_PROVIDER_LITERAL = new ExtensionType(DEVICE_DESCRIPTION_PROVIDER, "DEVICE_DESCRIPTION_PROVIDER");

	/**
	 * The '<em><b>PERSISTENT STORE PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PERSISTENT_STORE_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType PERSISTENT_STORE_PROVIDER_LITERAL = new ExtensionType(PERSISTENT_STORE_PROVIDER, "PERSISTENT_STORE_PROVIDER");

	/**
	 * The '<em><b>DEPLOYMENT PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #DEPLOYMENT_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType DEPLOYMENT_PROVIDER_LITERAL = new ExtensionType(DEPLOYMENT_PROVIDER, "DEPLOYMENT_PROVIDER");

	/**
	 * The '<em><b>PREVERIFICATION PROVIDER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PREVERIFICATION_PROVIDER
	 * @generated
	 * @ordered
	 */
	public static final ExtensionType PREVERIFICATION_PROVIDER_LITERAL = new ExtensionType(PREVERIFICATION_PROVIDER, "PREVERIFICATION_PROVIDER");

	/**
	 * An array of all the '<em><b>Extension Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ExtensionType[] VALUES_ARRAY =
		new ExtensionType[] {
			ADMIN_GUI_PROVIDER_LITERAL,
			BUILD_MANAGEMENT_LITERAL,
			BUILD_PROVIDER_LITERAL,
			DEPLOYMENT_MANAGEMENT_LITERAL,
			DEVICE_PLATFORM_PROVIDER_LITERAL,
			GUI_BUILDER_MANAGEMENT_LITERAL,
			GUI_BUILDER_PROVIDER_LITERAL,
			PACKAGING_PROVIDER_LITERAL,
			PREPROCESSING_PROVIDER_LITERAL,
			OBFUSCATION_PROVIDER_LITERAL,
			SCREEN_ENGINE_PROVIDER_LITERAL,
			SECURITY_MANAGEMENT_LITERAL,
			SIGNING_PROVIDER_LITERAL,
			DRM_ENCODING_PROVIDER_LITERAL,
			DEVICE_MANAGEMENT_LITERAL,
			DEVICE_DESCRIPTION_PROVIDER_LITERAL,
			PERSISTENT_STORE_PROVIDER_LITERAL,
			DEPLOYMENT_PROVIDER_LITERAL,
			PREVERIFICATION_PROVIDER_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Extension Type</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Extension Type</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ExtensionType get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ExtensionType result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Extension Type</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ExtensionType get(int value) {
		switch (value) {
			case ADMIN_GUI_PROVIDER: return ADMIN_GUI_PROVIDER_LITERAL;
			case BUILD_MANAGEMENT: return BUILD_MANAGEMENT_LITERAL;
			case BUILD_PROVIDER: return BUILD_PROVIDER_LITERAL;
			case DEPLOYMENT_MANAGEMENT: return DEPLOYMENT_MANAGEMENT_LITERAL;
			case DEVICE_PLATFORM_PROVIDER: return DEVICE_PLATFORM_PROVIDER_LITERAL;
			case GUI_BUILDER_MANAGEMENT: return GUI_BUILDER_MANAGEMENT_LITERAL;
			case GUI_BUILDER_PROVIDER: return GUI_BUILDER_PROVIDER_LITERAL;
			case PACKAGING_PROVIDER: return PACKAGING_PROVIDER_LITERAL;
			case PREPROCESSING_PROVIDER: return PREPROCESSING_PROVIDER_LITERAL;
			case OBFUSCATION_PROVIDER: return OBFUSCATION_PROVIDER_LITERAL;
			case SCREEN_ENGINE_PROVIDER: return SCREEN_ENGINE_PROVIDER_LITERAL;
			case SECURITY_MANAGEMENT: return SECURITY_MANAGEMENT_LITERAL;
			case SIGNING_PROVIDER: return SIGNING_PROVIDER_LITERAL;
			case DRM_ENCODING_PROVIDER: return DRM_ENCODING_PROVIDER_LITERAL;
			case DEVICE_MANAGEMENT: return DEVICE_MANAGEMENT_LITERAL;
			case DEVICE_DESCRIPTION_PROVIDER: return DEVICE_DESCRIPTION_PROVIDER_LITERAL;
			case PERSISTENT_STORE_PROVIDER: return PERSISTENT_STORE_PROVIDER_LITERAL;
			case DEPLOYMENT_PROVIDER: return DEPLOYMENT_PROVIDER_LITERAL;
			case PREVERIFICATION_PROVIDER: return PREVERIFICATION_PROVIDER_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ExtensionType(int value, String name) {
		super(value, name);
	}

} //ExtensionType
