/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.mtj.api.enumerations.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class EnumerationsFactoryImpl extends EFactoryImpl implements EnumerationsFactory {
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationsFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case EnumerationsPackage.CAPABILITY: {
				Capability result = Capability.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.BUILD_TYPE: {
				BuildType result = BuildType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.EXTENSION_TYPE: {
				ExtensionType result = ExtensionType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.ACTION_TYPE: {
				ActionType result = ActionType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.DEPLOYMENT_TYPE: {
				DeploymentType result = DeploymentType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.DEVICE_COMMUNICATION_PROTOCOL: {
				DeviceCommunicationProtocol result = DeviceCommunicationProtocol.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.PLATFORM_TYPE: {
				PlatformType result = PlatformType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.EXPRESSION: {
				Expression result = Expression.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.PROJECT_TYPE: {
				ProjectType result = ProjectType.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			case EnumerationsPackage.DEVICE_STATUS: {
				DeviceStatus result = DeviceStatus.get(initialValue);
				if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
				return result;
			}
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case EnumerationsPackage.CAPABILITY:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.BUILD_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.EXTENSION_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.ACTION_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.DEPLOYMENT_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.DEVICE_COMMUNICATION_PROTOCOL:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.PLATFORM_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.EXPRESSION:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.PROJECT_TYPE:
				return instanceValue == null ? null : instanceValue.toString();
			case EnumerationsPackage.DEVICE_STATUS:
				return instanceValue == null ? null : instanceValue.toString();
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EnumerationsPackage getEnumerationsPackage() {
		return (EnumerationsPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static EnumerationsPackage getPackage() {
		return EnumerationsPackage.eINSTANCE;
	}

} //EnumerationsFactoryImpl
