/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Target Device</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getSigningDetails <em>Signing Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getPreprocessingDetails <em>Preprocessing Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getRuntimePlatform <em>Runtime Platform</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getDevicePlatformName <em>Device Platform Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceName <em>Device Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceGroupName <em>Device Group Name</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice()
 * @model
 * @generated
 */
public interface TargetDevice extends EObject {
	/**
	 * Returns the value of the '<em><b>Signing Details</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.project.SigningDetail}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Signing Details</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Signing Details</em>' containment reference list.
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_SigningDetails()
	 * @model type="org.eclipse.mtj.api.project.SigningDetail" containment="true"
	 * @generated
	 */
	EList getSigningDetails();

	/**
	 * Returns the value of the '<em><b>Preprocessing Details</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.project.PreprocessingDetail}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Preprocessing Details</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Preprocessing Details</em>' containment reference list.
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_PreprocessingDetails()
	 * @model type="org.eclipse.mtj.api.project.PreprocessingDetail" containment="true"
	 * @generated
	 */
	EList getPreprocessingDetails();

	/**
	 * Returns the value of the '<em><b>Runtime Platform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Platform</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Platform</em>' containment reference.
	 * @see #setRuntimePlatform(RuntimePlatformDefinition)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_RuntimePlatform()
	 * @model containment="true" required="true"
	 * @generated
	 */
	RuntimePlatformDefinition getRuntimePlatform();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getRuntimePlatform <em>Runtime Platform</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Runtime Platform</em>' containment reference.
	 * @see #getRuntimePlatform()
	 * @generated
	 */
	void setRuntimePlatform(RuntimePlatformDefinition value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Device Platform Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Platform Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Platform Name</em>' attribute.
	 * @see #setDevicePlatformName(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_DevicePlatformName()
	 * @model
	 * @generated
	 */
	String getDevicePlatformName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getDevicePlatformName <em>Device Platform Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Platform Name</em>' attribute.
	 * @see #getDevicePlatformName()
	 * @generated
	 */
	void setDevicePlatformName(String value);

	/**
	 * Returns the value of the '<em><b>Device Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Name</em>' attribute.
	 * @see #setDeviceName(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_DeviceName()
	 * @model
	 * @generated
	 */
	String getDeviceName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceName <em>Device Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Name</em>' attribute.
	 * @see #getDeviceName()
	 * @generated
	 */
	void setDeviceName(String value);

	/**
	 * Returns the value of the '<em><b>Device Group Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Group Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Group Name</em>' attribute.
	 * @see #setDeviceGroupName(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getTargetDevice_DeviceGroupName()
	 * @model
	 * @generated
	 */
	String getDeviceGroupName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceGroupName <em>Device Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Group Name</em>' attribute.
	 * @see #getDeviceGroupName()
	 * @generated
	 */
	void setDeviceGroupName(String value);

} // TargetDevice
