/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.project.PreprocessingDetail;
import org.eclipse.mtj.api.project.ProjectPackage;
import org.eclipse.mtj.api.project.SigningDetail;
import org.eclipse.mtj.api.project.TargetDevice;

import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Target Device</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getSigningDetails <em>Signing Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getPreprocessingDetails <em>Preprocessing Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getRuntimePlatform <em>Runtime Platform</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getDevicePlatformName <em>Device Platform Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getDeviceName <em>Device Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl#getDeviceGroupName <em>Device Group Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TargetDeviceImpl extends EObjectImpl implements TargetDevice {
	/**
	 * The cached value of the '{@link #getSigningDetails() <em>Signing Details</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSigningDetails()
	 * @generated
	 * @ordered
	 */
	protected EList signingDetails = null;

	/**
	 * The cached value of the '{@link #getPreprocessingDetails() <em>Preprocessing Details</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getPreprocessingDetails()
	 * @generated
	 * @ordered
	 */
	protected EList preprocessingDetails = null;

	/**
	 * The cached value of the '{@link #getRuntimePlatform() <em>Runtime Platform</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimePlatform()
	 * @generated
	 * @ordered
	 */
	protected RuntimePlatformDefinition runtimePlatform = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getDevicePlatformName() <em>Device Platform Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDevicePlatformName()
	 * @generated
	 * @ordered
	 */
	protected static final String DEVICE_PLATFORM_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDevicePlatformName() <em>Device Platform Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDevicePlatformName()
	 * @generated
	 * @ordered
	 */
	protected String devicePlatformName = DEVICE_PLATFORM_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDeviceName() <em>Device Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceName()
	 * @generated
	 * @ordered
	 */
	protected static final String DEVICE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDeviceName() <em>Device Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceName()
	 * @generated
	 * @ordered
	 */
	protected String deviceName = DEVICE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDeviceGroupName() <em>Device Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceGroupName()
	 * @generated
	 * @ordered
	 */
	protected static final String DEVICE_GROUP_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDeviceGroupName() <em>Device Group Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceGroupName()
	 * @generated
	 * @ordered
	 */
	protected String deviceGroupName = DEVICE_GROUP_NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetDeviceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return ProjectPackage.eINSTANCE.getTargetDevice();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getSigningDetails() {
		if (signingDetails == null) {
			signingDetails = new EObjectContainmentEList(SigningDetail.class, this, ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS);
		}
		return signingDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getPreprocessingDetails() {
		if (preprocessingDetails == null) {
			preprocessingDetails = new EObjectContainmentEList(PreprocessingDetail.class, this, ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS);
		}
		return preprocessingDetails;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimePlatformDefinition getRuntimePlatform() {
		return runtimePlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRuntimePlatform(RuntimePlatformDefinition newRuntimePlatform, NotificationChain msgs) {
		RuntimePlatformDefinition oldRuntimePlatform = runtimePlatform;
		runtimePlatform = newRuntimePlatform;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM, oldRuntimePlatform, newRuntimePlatform);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRuntimePlatform(RuntimePlatformDefinition newRuntimePlatform) {
		if (newRuntimePlatform != runtimePlatform) {
			NotificationChain msgs = null;
			if (runtimePlatform != null)
				msgs = ((InternalEObject)runtimePlatform).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM, null, msgs);
			if (newRuntimePlatform != null)
				msgs = ((InternalEObject)newRuntimePlatform).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM, null, msgs);
			msgs = basicSetRuntimePlatform(newRuntimePlatform, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM, newRuntimePlatform, newRuntimePlatform));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDevicePlatformName() {
		return devicePlatformName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDevicePlatformName(String newDevicePlatformName) {
		String oldDevicePlatformName = devicePlatformName;
		devicePlatformName = newDevicePlatformName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__DEVICE_PLATFORM_NAME, oldDevicePlatformName, devicePlatformName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDeviceName() {
		return deviceName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeviceName(String newDeviceName) {
		String oldDeviceName = deviceName;
		deviceName = newDeviceName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__DEVICE_NAME, oldDeviceName, deviceName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDeviceGroupName() {
		return deviceGroupName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeviceGroupName(String newDeviceGroupName) {
		String oldDeviceGroupName = deviceGroupName;
		deviceGroupName = newDeviceGroupName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ProjectPackage.TARGET_DEVICE__DEVICE_GROUP_NAME, oldDeviceGroupName, deviceGroupName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS:
					return ((InternalEList)getSigningDetails()).basicRemove(otherEnd, msgs);
				case ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS:
					return ((InternalEList)getPreprocessingDetails()).basicRemove(otherEnd, msgs);
				case ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM:
					return basicSetRuntimePlatform(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS:
				return getSigningDetails();
			case ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS:
				return getPreprocessingDetails();
			case ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM:
				return getRuntimePlatform();
			case ProjectPackage.TARGET_DEVICE__NAME:
				return getName();
			case ProjectPackage.TARGET_DEVICE__DESCRIPTION:
				return getDescription();
			case ProjectPackage.TARGET_DEVICE__DEVICE_PLATFORM_NAME:
				return getDevicePlatformName();
			case ProjectPackage.TARGET_DEVICE__DEVICE_NAME:
				return getDeviceName();
			case ProjectPackage.TARGET_DEVICE__DEVICE_GROUP_NAME:
				return getDeviceGroupName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS:
				getSigningDetails().clear();
				getSigningDetails().addAll((Collection)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS:
				getPreprocessingDetails().clear();
				getPreprocessingDetails().addAll((Collection)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM:
				setRuntimePlatform((RuntimePlatformDefinition)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__NAME:
				setName((String)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_PLATFORM_NAME:
				setDevicePlatformName((String)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_NAME:
				setDeviceName((String)newValue);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_GROUP_NAME:
				setDeviceGroupName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS:
				getSigningDetails().clear();
				return;
			case ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS:
				getPreprocessingDetails().clear();
				return;
			case ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM:
				setRuntimePlatform((RuntimePlatformDefinition)null);
				return;
			case ProjectPackage.TARGET_DEVICE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case ProjectPackage.TARGET_DEVICE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_PLATFORM_NAME:
				setDevicePlatformName(DEVICE_PLATFORM_NAME_EDEFAULT);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_NAME:
				setDeviceName(DEVICE_NAME_EDEFAULT);
				return;
			case ProjectPackage.TARGET_DEVICE__DEVICE_GROUP_NAME:
				setDeviceGroupName(DEVICE_GROUP_NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case ProjectPackage.TARGET_DEVICE__SIGNING_DETAILS:
				return signingDetails != null && !signingDetails.isEmpty();
			case ProjectPackage.TARGET_DEVICE__PREPROCESSING_DETAILS:
				return preprocessingDetails != null && !preprocessingDetails.isEmpty();
			case ProjectPackage.TARGET_DEVICE__RUNTIME_PLATFORM:
				return runtimePlatform != null;
			case ProjectPackage.TARGET_DEVICE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case ProjectPackage.TARGET_DEVICE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case ProjectPackage.TARGET_DEVICE__DEVICE_PLATFORM_NAME:
				return DEVICE_PLATFORM_NAME_EDEFAULT == null ? devicePlatformName != null : !DEVICE_PLATFORM_NAME_EDEFAULT.equals(devicePlatformName);
			case ProjectPackage.TARGET_DEVICE__DEVICE_NAME:
				return DEVICE_NAME_EDEFAULT == null ? deviceName != null : !DEVICE_NAME_EDEFAULT.equals(deviceName);
			case ProjectPackage.TARGET_DEVICE__DEVICE_GROUP_NAME:
				return DEVICE_GROUP_NAME_EDEFAULT == null ? deviceGroupName != null : !DEVICE_GROUP_NAME_EDEFAULT.equals(deviceGroupName);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", description: ");
		result.append(description);
		result.append(", devicePlatformName: ");
		result.append(devicePlatformName);
		result.append(", deviceName: ");
		result.append(deviceName);
		result.append(", deviceGroupName: ");
		result.append(deviceGroupName);
		result.append(')');
		return result.toString();
	}

} //TargetDeviceImpl
