/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Device Configuration</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getImplementation <em>Implementation</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getJvmRef <em>Jvm Ref</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getVersion <em>Version</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceConfiguration()
 * @model
 * @generated
 */
public interface DeviceConfiguration extends EObject {
	/**
	 * Returns the value of the '<em><b>Implementation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Implementation</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Implementation</em>' containment reference.
	 * @see #setImplementation(ImplementationRef)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceConfiguration_Implementation()
	 * @model containment="true" required="true"
	 * @generated
	 */
	ImplementationRef getImplementation();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getImplementation <em>Implementation</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Implementation</em>' containment reference.
	 * @see #getImplementation()
	 * @generated
	 */
	void setImplementation(ImplementationRef value);

	/**
	 * Returns the value of the '<em><b>Jvm Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Jvm Ref</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Jvm Ref</em>' containment reference.
	 * @see #setJvmRef(JvmImplementation)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceConfiguration_JvmRef()
	 * @model containment="true"
	 * @generated
	 */
	JvmImplementation getJvmRef();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getJvmRef <em>Jvm Ref</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Jvm Ref</em>' containment reference.
	 * @see #getJvmRef()
	 * @generated
	 */
	void setJvmRef(JvmImplementation value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceConfiguration_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceConfiguration_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

} // DeviceConfiguration
