/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Device Profile</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getServiceApis <em>Service Apis</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getVersion <em>Version</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceProfile()
 * @model
 * @generated
 */
public interface DeviceProfile extends EObject {
	/**
	 * Returns the value of the '<em><b>Service Apis</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.ServiceApi}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Service Apis</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Service Apis</em>' reference list.
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceProfile_ServiceApis()
	 * @model type="org.eclipse.mtj.api.runtimes.ServiceApi" required="true"
	 * @generated
	 */
	EList getServiceApis();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceProfile_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.mtj.api.runtimes.RuntimesPackage#getDeviceProfile_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

} // DeviceProfile
