/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.runtimes.RuntimesFactory
 * @model kind="package"
 * @generated
 */
public interface RuntimesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "runtimes";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/runtimes.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.runtimes";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	RuntimesPackage eINSTANCE = org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl <em>Runtime Platform Definition</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getRuntimePlatformDefinition()
	 * @generated
	 */
	int RUNTIME_PLATFORM_DEFINITION = 0;

	/**
	 * The feature id for the '<em><b>Devices</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION__DEVICES = 0;

	/**
	 * The feature id for the '<em><b>Device Profiles</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES = 1;

	/**
	 * The feature id for the '<em><b>Service Apis</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS = 2;

	/**
	 * The feature id for the '<em><b>Device Configurations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION__NAME = 4;

	/**
	 * The number of structural features of the the '<em>Runtime Platform Definition</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_DEFINITION_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.DeviceProfileImpl <em>Device Profile</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.DeviceProfileImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getDeviceProfile()
	 * @generated
	 */
	int DEVICE_PROFILE = 1;

	/**
	 * The feature id for the '<em><b>Service Apis</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PROFILE__SERVICE_APIS = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PROFILE__NAME = 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PROFILE__VERSION = 2;

	/**
	 * The number of structural features of the the '<em>Device Profile</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_PROFILE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.ServiceApiImpl <em>Service Api</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.ServiceApiImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getServiceApi()
	 * @generated
	 */
	int SERVICE_API = 2;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_API__IMPLEMENTATION = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_API__NAME = 1;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_API__VERSION = 2;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_API__DESCRIPTION = 3;

	/**
	 * The number of structural features of the the '<em>Service Api</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SERVICE_API_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl <em>Device Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.DeviceConfigurationImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getDeviceConfiguration()
	 * @generated
	 */
	int DEVICE_CONFIGURATION = 3;

	/**
	 * The feature id for the '<em><b>Implementation</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CONFIGURATION__IMPLEMENTATION = 0;

	/**
	 * The feature id for the '<em><b>Jvm Ref</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CONFIGURATION__JVM_REF = 1;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CONFIGURATION__NAME = 2;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CONFIGURATION__VERSION = 3;

	/**
	 * The number of structural features of the the '<em>Device Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEVICE_CONFIGURATION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.ImplementationRefImpl <em>Implementation Ref</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.ImplementationRefImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getImplementationRef()
	 * @generated
	 */
	int IMPLEMENTATION_REF = 4;

	/**
	 * The feature id for the '<em><b>File Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPLEMENTATION_REF__FILE_REF = 0;

	/**
	 * The feature id for the '<em><b>Source Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPLEMENTATION_REF__SOURCE_REF = 1;

	/**
	 * The feature id for the '<em><b>Javadoc Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPLEMENTATION_REF__JAVADOC_REF = 2;

	/**
	 * The number of structural features of the the '<em>Implementation Ref</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int IMPLEMENTATION_REF_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl <em>Jvm Implementation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getJvmImplementation()
	 * @generated
	 */
	int JVM_IMPLEMENTATION = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JVM_IMPLEMENTATION__NAME = 0;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JVM_IMPLEMENTATION__VERSION = 1;

	/**
	 * The feature id for the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JVM_IMPLEMENTATION__VENDOR = 2;

	/**
	 * The feature id for the '<em><b>File Ref</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JVM_IMPLEMENTATION__FILE_REF = 3;

	/**
	 * The number of structural features of the the '<em>Jvm Implementation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JVM_IMPLEMENTATION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformImpl <em>Runtime Platform</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimePlatformImpl
	 * @see org.eclipse.mtj.api.runtimes.impl.RuntimesPackageImpl#getRuntimePlatform()
	 * @generated
	 */
	int RUNTIME_PLATFORM = 6;

	/**
	 * The feature id for the '<em><b>Target Devices</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM__TARGET_DEVICES = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM__NAME = 1;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM__DESCRIPTION = 2;

	/**
	 * The number of structural features of the the '<em>Runtime Platform</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RUNTIME_PLATFORM_FEATURE_COUNT = 3;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition <em>Runtime Platform Definition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runtime Platform Definition</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition
	 * @generated
	 */
	EClass getRuntimePlatformDefinition();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices <em>Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Devices</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices()
	 * @see #getRuntimePlatformDefinition()
	 * @generated
	 */
	EReference getRuntimePlatformDefinition_Devices();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceProfiles <em>Device Profiles</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Device Profiles</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceProfiles()
	 * @see #getRuntimePlatformDefinition()
	 * @generated
	 */
	EReference getRuntimePlatformDefinition_DeviceProfiles();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getServiceApis <em>Service Apis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Service Apis</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getServiceApis()
	 * @see #getRuntimePlatformDefinition()
	 * @generated
	 */
	EReference getRuntimePlatformDefinition_ServiceApis();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceConfigurations <em>Device Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Device Configurations</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDeviceConfigurations()
	 * @see #getRuntimePlatformDefinition()
	 * @generated
	 */
	EReference getRuntimePlatformDefinition_DeviceConfigurations();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getName()
	 * @see #getRuntimePlatformDefinition()
	 * @generated
	 */
	EAttribute getRuntimePlatformDefinition_Name();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.DeviceProfile <em>Device Profile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Profile</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile
	 * @generated
	 */
	EClass getDeviceProfile();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getServiceApis <em>Service Apis</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Service Apis</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getServiceApis()
	 * @see #getDeviceProfile()
	 * @generated
	 */
	EReference getDeviceProfile_ServiceApis();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getName()
	 * @see #getDeviceProfile()
	 * @generated
	 */
	EAttribute getDeviceProfile_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.DeviceProfile#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceProfile#getVersion()
	 * @see #getDeviceProfile()
	 * @generated
	 */
	EAttribute getDeviceProfile_Version();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.ServiceApi <em>Service Api</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Service Api</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ServiceApi
	 * @generated
	 */
	EClass getServiceApi();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.runtimes.ServiceApi#getImplementation <em>Implementation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Implementation</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ServiceApi#getImplementation()
	 * @see #getServiceApi()
	 * @generated
	 */
	EReference getServiceApi_Implementation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ServiceApi#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ServiceApi#getName()
	 * @see #getServiceApi()
	 * @generated
	 */
	EAttribute getServiceApi_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ServiceApi#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ServiceApi#getVersion()
	 * @see #getServiceApi()
	 * @generated
	 */
	EAttribute getServiceApi_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ServiceApi#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ServiceApi#getDescription()
	 * @see #getServiceApi()
	 * @generated
	 */
	EAttribute getServiceApi_Description();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration <em>Device Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Device Configuration</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceConfiguration
	 * @generated
	 */
	EClass getDeviceConfiguration();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getImplementation <em>Implementation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Implementation</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceConfiguration#getImplementation()
	 * @see #getDeviceConfiguration()
	 * @generated
	 */
	EReference getDeviceConfiguration_Implementation();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getJvmRef <em>Jvm Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Jvm Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceConfiguration#getJvmRef()
	 * @see #getDeviceConfiguration()
	 * @generated
	 */
	EReference getDeviceConfiguration_JvmRef();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceConfiguration#getName()
	 * @see #getDeviceConfiguration()
	 * @generated
	 */
	EAttribute getDeviceConfiguration_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.DeviceConfiguration#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.runtimes.DeviceConfiguration#getVersion()
	 * @see #getDeviceConfiguration()
	 * @generated
	 */
	EAttribute getDeviceConfiguration_Version();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.ImplementationRef <em>Implementation Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Implementation Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ImplementationRef
	 * @generated
	 */
	EClass getImplementationRef();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ImplementationRef#getFileRef <em>File Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>File Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ImplementationRef#getFileRef()
	 * @see #getImplementationRef()
	 * @generated
	 */
	EAttribute getImplementationRef_FileRef();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ImplementationRef#getSourceRef <em>Source Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Source Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ImplementationRef#getSourceRef()
	 * @see #getImplementationRef()
	 * @generated
	 */
	EAttribute getImplementationRef_SourceRef();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.ImplementationRef#getJavadocRef <em>Javadoc Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Javadoc Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.ImplementationRef#getJavadocRef()
	 * @see #getImplementationRef()
	 * @generated
	 */
	EAttribute getImplementationRef_JavadocRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.JvmImplementation <em>Jvm Implementation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Jvm Implementation</em>'.
	 * @see org.eclipse.mtj.api.runtimes.JvmImplementation
	 * @generated
	 */
	EClass getJvmImplementation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.JvmImplementation#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.JvmImplementation#getName()
	 * @see #getJvmImplementation()
	 * @generated
	 */
	EAttribute getJvmImplementation_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.JvmImplementation#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.mtj.api.runtimes.JvmImplementation#getVersion()
	 * @see #getJvmImplementation()
	 * @generated
	 */
	EAttribute getJvmImplementation_Version();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.JvmImplementation#getVendor <em>Vendor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vendor</em>'.
	 * @see org.eclipse.mtj.api.runtimes.JvmImplementation#getVendor()
	 * @see #getJvmImplementation()
	 * @generated
	 */
	EAttribute getJvmImplementation_Vendor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.JvmImplementation#getFileRef <em>File Ref</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>File Ref</em>'.
	 * @see org.eclipse.mtj.api.runtimes.JvmImplementation#getFileRef()
	 * @see #getJvmImplementation()
	 * @generated
	 */
	EAttribute getJvmImplementation_FileRef();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.runtimes.RuntimePlatform <em>Runtime Platform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Runtime Platform</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatform
	 * @generated
	 */
	EClass getRuntimePlatform();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.runtimes.RuntimePlatform#getTargetDevices <em>Target Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target Devices</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatform#getTargetDevices()
	 * @see #getRuntimePlatform()
	 * @generated
	 */
	EReference getRuntimePlatform_TargetDevices();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.RuntimePlatform#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatform#getName()
	 * @see #getRuntimePlatform()
	 * @generated
	 */
	EAttribute getRuntimePlatform_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.runtimes.RuntimePlatform#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatform#getDescription()
	 * @see #getRuntimePlatform()
	 * @generated
	 */
	EAttribute getRuntimePlatform_Description();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RuntimesFactory getRuntimesFactory();

} //RuntimesPackage
