/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.mtj.api.runtimes.JvmImplementation;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Jvm Implementation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl#getVendor <em>Vendor</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.JvmImplementationImpl#getFileRef <em>File Ref</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class JvmImplementationImpl extends EObjectImpl implements JvmImplementation {
	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected static final String VENDOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected String vendor = VENDOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getFileRef() <em>File Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileRef()
	 * @generated
	 * @ordered
	 */
	protected static final String FILE_REF_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getFileRef() <em>File Ref</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFileRef()
	 * @generated
	 * @ordered
	 */
	protected String fileRef = FILE_REF_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JvmImplementationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RuntimesPackage.eINSTANCE.getJvmImplementation();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.JVM_IMPLEMENTATION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.JVM_IMPLEMENTATION__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVendor() {
		return vendor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVendor(String newVendor) {
		String oldVendor = vendor;
		vendor = newVendor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.JVM_IMPLEMENTATION__VENDOR, oldVendor, vendor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getFileRef() {
		return fileRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFileRef(String newFileRef) {
		String oldFileRef = fileRef;
		fileRef = newFileRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.JVM_IMPLEMENTATION__FILE_REF, oldFileRef, fileRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.JVM_IMPLEMENTATION__NAME:
				return getName();
			case RuntimesPackage.JVM_IMPLEMENTATION__VERSION:
				return getVersion();
			case RuntimesPackage.JVM_IMPLEMENTATION__VENDOR:
				return getVendor();
			case RuntimesPackage.JVM_IMPLEMENTATION__FILE_REF:
				return getFileRef();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.JVM_IMPLEMENTATION__NAME:
				setName((String)newValue);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__VERSION:
				setVersion((String)newValue);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__VENDOR:
				setVendor((String)newValue);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__FILE_REF:
				setFileRef((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.JVM_IMPLEMENTATION__NAME:
				setName(NAME_EDEFAULT);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__VENDOR:
				setVendor(VENDOR_EDEFAULT);
				return;
			case RuntimesPackage.JVM_IMPLEMENTATION__FILE_REF:
				setFileRef(FILE_REF_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.JVM_IMPLEMENTATION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case RuntimesPackage.JVM_IMPLEMENTATION__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case RuntimesPackage.JVM_IMPLEMENTATION__VENDOR:
				return VENDOR_EDEFAULT == null ? vendor != null : !VENDOR_EDEFAULT.equals(vendor);
			case RuntimesPackage.JVM_IMPLEMENTATION__FILE_REF:
				return FILE_REF_EDEFAULT == null ? fileRef != null : !FILE_REF_EDEFAULT.equals(fileRef);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(", version: ");
		result.append(version);
		result.append(", vendor: ");
		result.append(vendor);
		result.append(", fileRef: ");
		result.append(fileRef);
		result.append(')');
		return result.toString();
	}

} //JvmImplementationImpl
