/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.signings;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Signing Certificate</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystore <em>Keystore</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.SigningCertificate#getAliasName <em>Alias Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystorePassword <em>Keystore Password</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.signings.SigningCertificate#getCertificatePassword <em>Certificate Password</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.signings.SigningsPackage#getSigningCertificate()
 * @model
 * @generated
 */
public interface SigningCertificate extends EObject {
	/**
	 * Returns the value of the '<em><b>Keystore</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Keystore</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keystore</em>' attribute.
	 * @see #setKeystore(String)
	 * @see org.eclipse.mtj.api.signings.SigningsPackage#getSigningCertificate_Keystore()
	 * @model
	 * @generated
	 */
	String getKeystore();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystore <em>Keystore</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keystore</em>' attribute.
	 * @see #getKeystore()
	 * @generated
	 */
	void setKeystore(String value);

	/**
	 * Returns the value of the '<em><b>Alias Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Alias Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Alias Name</em>' attribute.
	 * @see #setAliasName(String)
	 * @see org.eclipse.mtj.api.signings.SigningsPackage#getSigningCertificate_AliasName()
	 * @model
	 * @generated
	 */
	String getAliasName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.signings.SigningCertificate#getAliasName <em>Alias Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Alias Name</em>' attribute.
	 * @see #getAliasName()
	 * @generated
	 */
	void setAliasName(String value);

	/**
	 * Returns the value of the '<em><b>Keystore Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Keystore Password</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keystore Password</em>' attribute.
	 * @see #setKeystorePassword(String)
	 * @see org.eclipse.mtj.api.signings.SigningsPackage#getSigningCertificate_KeystorePassword()
	 * @model
	 * @generated
	 */
	String getKeystorePassword();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.signings.SigningCertificate#getKeystorePassword <em>Keystore Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keystore Password</em>' attribute.
	 * @see #getKeystorePassword()
	 * @generated
	 */
	void setKeystorePassword(String value);

	/**
	 * Returns the value of the '<em><b>Certificate Password</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Certificate Password</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Certificate Password</em>' attribute.
	 * @see #setCertificatePassword(String)
	 * @see org.eclipse.mtj.api.signings.SigningsPackage#getSigningCertificate_CertificatePassword()
	 * @model
	 * @generated
	 */
	String getCertificatePassword();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.signings.SigningCertificate#getCertificatePassword <em>Certificate Password</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Certificate Password</em>' attribute.
	 * @see #getCertificatePassword()
	 * @generated
	 */
	void setCertificatePassword(String value);

} // SigningCertificate
