/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.preferences;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentManagement;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.extension.dplm.ui.DeploymentManagementUIMessages;
import org.eclipse.mtj.extension.dplm.ui.dialog.DialogConstants;
import org.eclipse.mtj.extension.dplm.ui.properties.DeploymentPropertyPage;
import org.eclipse.mtj.extension.dplm.ui.test.TestUtils;
import org.eclipse.mtj.extension.dplm.ui.util.DevicesContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.DevicesLabelProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersContentProvider;
import org.eclipse.mtj.extension.dplm.ui.util.ProvidersLabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DeploymentManagementPreferencePage
	extends PreferencePage
	implements IWorkbenchPreferencePage {

    private TableViewer devicesViewer;
    private TableViewer providersViewer;
    private Button btnDeviceProperties, btnRefreshList, btnProviderProperties;
    private Label lblDescription;
    
    private ProvidersLabelProvider pLabelProvider = new ProvidersLabelProvider((DeploymentManagement) (MtjServices.getInstance()
												.getImplementations( ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL, null,	null))[0]);
    private ProvidersContentProvider pContentProvider = new ProvidersContentProvider();
    private DevicesLabelProvider dLabelProvider = new DevicesLabelProvider();
    private DevicesContentProvider dContentProvider = new DevicesContentProvider();

    
	public DeploymentManagementPreferencePage() {
		//super();
		//setPreferenceStore(DeploymentManagementUIPlugin.getDefault().getPreferenceStore());
		setDescription(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_DeploymentPreferencePageDescription);
	}
    
    
    protected Control createContents(Composite parent) {
        GridData data;
        GridLayout layout;
        FillLayout fillLayout;
        Composite result = new Composite(parent, SWT.NONE);

        // TODO replace static strings
        
        Link lnkProjectSettings = new Link(result, SWT.NONE);
        GridData gd = new GridData(GridData.FILL_HORIZONTAL);
        lnkProjectSettings.setLayoutData(gd);
        lnkProjectSettings.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_ConfigureProjectSpecificSettings);
        lnkProjectSettings.setToolTipText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_ConfigureProjectSpecificSettingsToolTip);

        lnkProjectSettings.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
                DeploymentPropertyPage propertyPage = new DeploymentPropertyPage();
                
                
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                // TODO Auto-generated method stub
            }
        });
        
        Group grpProviders = new Group(result, SWT.NONE);
        grpProviders.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Providers); 
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 3;
        data.heightHint = 130;
        data.widthHint = 400;
        grpProviders.setLayoutData(data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        grpProviders.setLayout(layout);
       
        Composite listGrp = new Composite(grpProviders, SWT.NULL);
        fillLayout = new FillLayout();
        listGrp.setLayout(fillLayout);
        gd = new GridData(GridData.FILL_BOTH);
        listGrp.setLayoutData(gd);
               
        providersViewer = new TableViewer(listGrp, SWT.BORDER | SWT.CHECK | SWT.H_SCROLL);
        pContentProvider.setFilters(DialogConstants.ALL_DEVICES, DialogConstants.ALL_DEVICES_STATUS, DialogConstants.ALL_PROTOCOLS);
        providersViewer.setContentProvider(pContentProvider);
        providersViewer.setLabelProvider(pLabelProvider);
        providersViewer.setInput(TestUtils.getDevices());
        
        providersViewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                if(event.getSelection().isEmpty()) {
                    lblDescription.setText(""); //$NON-NLS-1$
                    // TODO clear device table
                    return;
                }
                if(event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    Object domain = null;
                    for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
                        domain = iterator.next();
                        String value = pLabelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", "); //$NON-NLS-1$
                    }
                    // remove the trailing comma space pair
                    if(toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    lblDescription.setText(toShow.toString());
                    List<Device> deviceList = new Vector<Device>();
                    for(Device device : (Device[])pContentProvider.getChildren(domain)) deviceList.add(device);
                    devicesViewer.setInput(deviceList);
                }

            }
            
        });
        
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout(layout);
        data = GridUtil.createFill();
        result.setLayoutData(data);
       
        Composite buttonWidget = new Composite(grpProviders, SWT.NULL);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = GridData.BEGINNING;     
        buttonWidget.setLayoutData(data);
        GridLayout blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout(blayout);
        
        btnProviderProperties = new Button(buttonWidget, SWT.NONE);
        initializeDialogUnits(btnProviderProperties);
        setButtonLayoutData(btnProviderProperties);
        btnProviderProperties.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Properties);
        
        Group grpDevices = new Group(result, SWT.NONE);
        grpDevices.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Devices); 
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 3;
        data.heightHint = 130;
        data.widthHint = 400;
        grpDevices.setLayoutData(data);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        grpDevices.setLayout(layout);
        
        listGrp = new Composite(grpDevices, SWT.NULL);     
        fillLayout = new FillLayout();
        listGrp.setLayout(fillLayout);
        gd = new GridData(GridData.FILL_BOTH);
        listGrp.setLayoutData(gd);

        devicesViewer = new TableViewer(listGrp, SWT.BORDER | SWT.CHECK | SWT.H_SCROLL);
        devicesViewer.setContentProvider(dContentProvider);
        devicesViewer.setLabelProvider(dLabelProvider);

        devicesViewer.addSelectionChangedListener(new ISelectionChangedListener() {

            public void selectionChanged(SelectionChangedEvent event) {
                if(event.getSelection().isEmpty()) {
                    lblDescription.setText(""); //$NON-NLS-1$
                    // TODO clear device table
                    return;
                }
                if(event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    StringBuffer toShow = new StringBuffer();
                    Object domain = null;
                    for (Iterator iterator = selection.iterator(); iterator.hasNext();) {
                        domain = iterator.next();
                        String value = pLabelProvider.getDescription(domain);
                        toShow.append(value);
                        toShow.append(", "); //$NON-NLS-1$
                    }
                    // remove the trailing comma space pair
                    if(toShow.length() > 0) {
                        toShow.setLength(toShow.length() - 2);
                    }
                    lblDescription.setText(toShow.toString());
                }

            }
            
        });
        
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 15;
        result.setLayout(layout);
        data = GridUtil.createFill();
        result.setLayoutData(data);
        
        buttonWidget = new Composite(grpDevices, SWT.NULL);
        data = new GridData();
        data.grabExcessVerticalSpace = true;
        data.horizontalIndent = 20;
        data.verticalAlignment = GridData.BEGINNING;     
        buttonWidget.setLayoutData(data);
        blayout = new GridLayout();
        blayout.numColumns = 1;
        buttonWidget.setLayout(blayout);
       
        btnDeviceProperties = new Button(buttonWidget, SWT.NONE);
        initializeDialogUnits(btnDeviceProperties);
        setButtonLayoutData(btnDeviceProperties);
        btnDeviceProperties.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Properties);
        
        btnRefreshList = new Button(buttonWidget, SWT.NONE);
        initializeDialogUnits(btnRefreshList);
        setButtonLayoutData(btnRefreshList);
        btnRefreshList.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_RefreshList);
        
        Group grpDescription = new Group(result, SWT.NONE);
        grpDescription.setText(DeploymentManagementUIMessages.DeploymentManagementPreferencePage_Description); 
        data = new GridData(GridData.FILL_BOTH);
        data.horizontalSpan = 3;
        data.heightHint = 70;
        data.widthHint = 400;
        grpDescription.setLayoutData(data);
        layout = new GridLayout();
        grpDescription.setLayout(layout);
        
        listGrp = new Composite(grpDescription, SWT.NULL);
        listGrp.setLayoutData(GridUtil.createFill());
        listGrp.setLayout(new GridLayout());
        
        lblDescription = new Label(grpDescription, SWT.WRAP);
        data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL | GridData.VERTICAL_ALIGN_FILL
                | GridData.GRAB_VERTICAL);
       
        data.horizontalSpan = 3;
        lblDescription.setLayoutData(data);
        
        return result;
    }
    
    


	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

    private Button createButton(Composite parent, String label){

        GridData data;
        Button btn = new Button(parent, SWT.NULL);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = GridData.FILL;
        btn.setLayoutData(data);
        btn.setText(label);
        return btn;
    
    }
}