/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.test;

import java.util.List;
import java.util.Vector;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.api.devices.impl.DevicesFactoryImpl;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.exception.MtjException;

public class TestDeploymentProviderImpl extends MtjExtensionImpl implements DeploymentProvider{

    private String name = ""; //$NON-NLS-1$
    private String description = ""; //$NON-NLS-1$
    
    TestDeploymentProviderImpl(String name, String description){
        this.name = name;
        this.description = description;
    }
    
    public Device[] getDevices() {
        Device[] devices = new Device[6]; 
        DevicesFactory devicesFactory = new DevicesFactoryImpl();
        
        for(int i=0; i<5; i++){
           devices[i] = (Device)devicesFactory.createDevice(); 
           devices[i].setName("Device " + i); //$NON-NLS-1$
           devices[i].setDescription("This is the device " + i + " and it has some of the following characteristics:" +  //$NON-NLS-1$ //$NON-NLS-2$
                                      "\n- it belongs to the platform type " + i + 1 + //$NON-NLS-1$
                                      "\n- the ID number is " + 1001 + i + "\n\nVendor: Nokia\n\nVersion: 1.0.1"); //$NON-NLS-1$ //$NON-NLS-2$
           devices[i].setVendor("Nokia"); //$NON-NLS-1$
           devices[i].setVersion("1.0.1"); //$NON-NLS-1$
        }
        devices[5] = (Device)devicesFactory.createDevice(); 
        devices[5].setName("Series 60 emulator"); //$NON-NLS-1$
        devices[5].setDescription("This is the Nokia Series 60 emulator"); //$NON-NLS-1$
        devices[5].setVendor("Nokia"); //$NON-NLS-1$
        devices[5].setVersion("1.0.0"); //$NON-NLS-1$
        
        return devices;
    }
    
    public Device[] getTargetDevices(){
		List<Device> targetDevices = new Vector<Device>();
		for(int i=0; i<getDevices().length; i++){
			if(getDevices()[i].getName().endsWith("2") || getDevices()[i].getName().endsWith("3") || getDevices()[i].getName().endsWith("emulator")){ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				targetDevices.add(getDevices()[i]);
			}
		}
		return (Device[])(targetDevices.toArray(new Device[targetDevices.size()]));
    }
    
    public boolean isConnected(Device device){
    	if(device.getName().endsWith("2") || device.getName().endsWith("4") || device.getName().endsWith("emulator")) return true; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    	return false;
    }

    public PlatformType getPlatformType() {
        // TODO Auto-generated method stub
        return null;
    }

    public DeviceCommunicationProtocol[] getSupportedProtocols() {
        // TODO Auto-generated method stub
        return null;
    }

    public void deploy(Deployment deployment, Device[] devices, DeviceCommunicationProtocol transferProtocol, IProgressMonitor monitor) {
        // TODO Auto-generated method stub

        
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

	public DeviceStatus getStatus(Device device) throws MtjException {
		// TODO Auto-generated method stub
    	if(device.getName().endsWith("2") || device.getName().endsWith("4") || device.getName().endsWith("emulator")){ //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
    		return DeviceStatus.DEVICE_STATUS_OK_LITERAL;
    	}
    	return DeviceStatus.DEVICE_STATUS_NOT_CONNECTED_LITERAL;
	}
    
    

}
