/*******************************************************************************
 * Copyright (c) 2005 Nokia Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.test;

import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class TestUtils {

	public static Object getDevices() {
		List<TestDeploymentProviderImpl> providers = new Vector<TestDeploymentProviderImpl>();

		providers.add(new TestDeploymentProviderImpl("Provider 1", //$NON-NLS-1$
				"Provider for Nokia Series 60 phones")); //$NON-NLS-1$
		providers.add(new TestDeploymentProviderImpl("Provider 2", //$NON-NLS-1$
				"Provider for Nokia Series 40 phones")); //$NON-NLS-1$
		providers.add(new TestDeploymentProviderImpl("Provider 3", //$NON-NLS-1$
				"Provider for Nokia Series 90 phones")); //$NON-NLS-1$

		return providers;
	}

	public static void deployS60Emulator(String resource) {
		
		String cmdline = "C:\\Nokia\\Devices\\Nokia_Prototype_SDK_4_0\\devices\\Prototype_4_0_S60_MIDP_Emulator\\bin\\emulator.exe -Xdescriptor:" + //$NON-NLS-1$
							"C:\\runtime-workspace" + resource; //$NON-NLS-1$
		Process p = null;
		Runtime runtime = null;
		try {
			runtime = Runtime.getRuntime();
			p = runtime.exec(cmdline);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

}
