/*******************************************************************************
 * Copyright (c) 2005 Nokia Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 *******************************************************************************/

package org.eclipse.mtj.extension.dplm.ui.util;

import java.util.List;
import java.util.Vector;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeploymentManagement;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.dplm.ui.dialog.DialogConstants;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class ProvidersContentProvider implements ITreeContentProvider {

	private int deviceFilter = DialogConstants.COMPATIBLE_DEVICES;

	private int statusFilter = DialogConstants.CONNECTED_DEVICES;

	private int protocolFilter = DialogConstants.PROJECT_DEFAULT_PROTOCOL;

	private IJavaProject javaProject = null;
	
	private DeploymentManagement dplmManagement = null;

	public Object[] getChildren(Object parentElement) {

		if (parentElement instanceof DeploymentProvider) {
			try {
				Object[] devices = (Object[]) ((DeploymentProvider) parentElement).getDevices();
				switch (deviceFilter) {
				case DialogConstants.COMPATIBLE_DEVICES:
					if(javaProject != null){
						try{
							IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
							Device[] targetDevices = null;
							if(mtjProject != null){
								RuntimePlatformDefinition runtimePlatformDefinition = mtjProject.getProjectData().getDefaultTargetDevice().getRuntimePlatform();
								DeploymentManagement deploymentManagement = (DeploymentManagement) MtjServices.getInstance().getImplementations(
																			ExtensionType.DEPLOYMENT_MANAGEMENT_LITERAL, null, null)[0];
								targetDevices = deploymentManagement.getTargetDevices(runtimePlatformDefinition);
							}
							if (statusFilter == DialogConstants.ALL_DEVICES_STATUS) {
								// return all compatible devices, either connected or not
								return targetDevices;
		
							} else {
								// TODO return only compatible devices that are also connected
								return getConnectedDevices((DeploymentProvider)parentElement, targetDevices);
							}
						}catch(MtjException e){
							return null;
						}
					}else{
						return null;
					}
				case DialogConstants.ALL_DEVICES:
					if (statusFilter == DialogConstants.ALL_DEVICES_STATUS) {
						return devices;
					} else {
						// TODO return all the connected devices
						return getConnectedDevices((DeploymentProvider)parentElement, (Device[])devices);
					}

				}

			} catch (MtjException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		return null;
	}

	/**
	 * @param parentElement
	 * @param targetDevices
	 * @return
	 */
	private Device[] getConnectedDevices(DeploymentProvider parentElement, Device[] targetDevices) {
		List<Device> connectedDevices = new Vector<Device>();
		if(targetDevices != null){
			for(int i=0; i<targetDevices.length; i++){
				try {
					if(((DeploymentProvider) parentElement).getStatus(targetDevices[i]).getValue() == DeviceStatus.DEVICE_STATUS_OK){
						connectedDevices.add(targetDevices[i]);
					}
				} catch (MtjException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			return (Device[]) connectedDevices.toArray(new Device[connectedDevices.size()]);
		}
		return null;
	}

	public Object getParent(Object element) {
		/*if(element instanceof Device) {
	        IWorkbenchAdapter adapter = getAdapter(element);
	        if (adapter != null) {
	            return adapter.getParent(element);
	        }
	    }*/
		return null;
	}

	public boolean hasChildren(Object element) {
		if (element instanceof DeploymentProvider) {

			DeploymentProvider provider = (DeploymentProvider) element;
			try {
				if (provider.getDevices() != null) {
					return true;
				} else {
					return false;
				}
			} catch (MtjException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} else if (element instanceof Device) {
			return true;
		}
		return false;
	}

	public Object[] getElements(Object inputElement) {
		return ((List) inputElement).toArray();
	}

	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		// TODO Auto-generated method stub

	}

	public void setFilters(int devices, int status, int protocol) {
		if (devices != 0)
			this.deviceFilter = devices;
		if (status != 0)
			this.statusFilter = status;
		if (protocol != 0)
			this.protocolFilter = protocol;
	}

	public void setJavaProject(IJavaProject javaProject) {
		this.javaProject = javaProject;
	}

	public void setDeploymentManagement(DeploymentManagement dplmManagement) {
		this.dplmManagement = dplmManagement;
	}

    protected IWorkbenchAdapter getAdapter(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        return (IWorkbenchAdapter) ((IAdaptable) element)
                .getAdapter(IWorkbenchAdapter.class);
    }
}
